/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Contains information about the text associated with a response.")
public class ResponseText
implements Serializable {
    private String content = null;
    private ContentTypeEnum contentType = null;
    private TypeEnum type = null;

    public ResponseText content(String content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Response text content.")
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ResponseText contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", value="Response text content type.")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public ResponseText type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Response text type.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseText responseText = (ResponseText)o;
        return Objects.equals(this.content, responseText.content) && Objects.equals((Object)this.contentType, (Object)responseText.contentType) && Objects.equals((Object)this.type, (Object)responseText.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.content, this.contentType, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseText {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContentTypeEnumDeserializer.class)
    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXT_PLAIN("text/plain"),
        TEXT_HTML("text/html");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BODY("body"),
        SUBJECT("subject");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ContentTypeEnumDeserializer
    extends StdDeserializer<ContentTypeEnum> {
        public ContentTypeEnumDeserializer() {
            super(ContentTypeEnumDeserializer.class);
        }

        public ContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

