/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.WorkPlanReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class WorkPlanOverride
implements Serializable {
    private LocalDate startDate = null;
    private Integer weekCount = null;
    private WorkPlanReference workPlan = null;

    public WorkPlanOverride startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The start date in yyyy-MM-dd format of the work plan override. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="startDate")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public WorkPlanOverride weekCount(Integer weekCount) {
        this.weekCount = weekCount;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Number of weeks for the work plan override")
    @JsonProperty(value="weekCount")
    public Integer getWeekCount() {
        return this.weekCount;
    }

    public void setWeekCount(Integer weekCount) {
        this.weekCount = weekCount;
    }

    public WorkPlanOverride workPlan(WorkPlanReference workPlan) {
        this.workPlan = workPlan;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The work plan reference associated with this override")
    @JsonProperty(value="workPlan")
    public WorkPlanReference getWorkPlan() {
        return this.workPlan;
    }

    public void setWorkPlan(WorkPlanReference workPlan) {
        this.workPlan = workPlan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkPlanOverride workPlanOverride = (WorkPlanOverride)o;
        return Objects.equals(this.startDate, workPlanOverride.startDate) && Objects.equals(this.weekCount, workPlanOverride.weekCount) && Objects.equals(this.workPlan, workPlanOverride.workPlan);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.weekCount, this.workPlan);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkPlanOverride {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    weekCount: ").append(this.toIndentedString(this.weekCount)).append("\n");
        sb.append("    workPlan: ").append(this.toIndentedString(this.workPlan)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

