/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class AiAnswer
implements Serializable {
    private String answerId = null;
    private String explanation = null;
    private FailureTypeEnum failureType = null;

    public AiAnswer answerId(String answerId) {
        this.answerId = answerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier of the suggested ai answer.")
    @JsonProperty(value="answerId")
    public String getAnswerId() {
        return this.answerId;
    }

    public void setAnswerId(String answerId) {
        this.answerId = answerId;
    }

    public AiAnswer explanation(String explanation) {
        this.explanation = explanation;
        return this;
    }

    @ApiModelProperty(example="null", value="An explanation providing the reasoning behind the suggested answer.")
    @JsonProperty(value="explanation")
    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public AiAnswer failureType(FailureTypeEnum failureType) {
        this.failureType = failureType;
        return this;
    }

    @ApiModelProperty(example="null", value="Describes the type of error associated with the AI answer.")
    @JsonProperty(value="failureType")
    public FailureTypeEnum getFailureType() {
        return this.failureType;
    }

    public void setFailureType(FailureTypeEnum failureType) {
        this.failureType = failureType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AiAnswer aiAnswer = (AiAnswer)o;
        return Objects.equals(this.answerId, aiAnswer.answerId) && Objects.equals(this.explanation, aiAnswer.explanation) && Objects.equals((Object)this.failureType, (Object)aiAnswer.failureType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.answerId, this.explanation, this.failureType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AiAnswer {\n");
        sb.append("    answerId: ").append(this.toIndentedString(this.answerId)).append("\n");
        sb.append("    explanation: ").append(this.toIndentedString(this.explanation)).append("\n");
        sb.append("    failureType: ").append(this.toIndentedString((Object)this.failureType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FailureTypeEnumDeserializer.class)
    public static enum FailureTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LOWCONFIDENCEERROR("LowConfidenceError"),
        PARSINGERROR("ParsingError"),
        SERVICEERROR("ServiceError");

        private String value;

        private FailureTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FailureTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FailureTypeEnum value : FailureTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FailureTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FailureTypeEnumDeserializer
    extends StdDeserializer<FailureTypeEnum> {
        public FailureTypeEnumDeserializer() {
            super(FailureTypeEnumDeserializer.class);
        }

        public FailureTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FailureTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

