/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Settings concerning cobrowse")
public class CobrowseSettings
implements Serializable {
    private Boolean enabled = null;
    private Boolean allowAgentControl = null;
    private Boolean allowAgentNavigation = null;
    private List<String> maskSelectors = new ArrayList<String>();
    private List<ChannelsEnum> channels = new ArrayList<ChannelsEnum>();
    private List<String> readonlySelectors = new ArrayList<String>();

    public CobrowseSettings enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not cobrowse is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CobrowseSettings allowAgentControl(Boolean allowAgentControl) {
        this.allowAgentControl = allowAgentControl;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the viewer should have option to request control")
    @JsonProperty(value="allowAgentControl")
    public Boolean getAllowAgentControl() {
        return this.allowAgentControl;
    }

    public void setAllowAgentControl(Boolean allowAgentControl) {
        this.allowAgentControl = allowAgentControl;
    }

    public CobrowseSettings allowAgentNavigation(Boolean allowAgentNavigation) {
        this.allowAgentNavigation = allowAgentNavigation;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the viewer should have option to request navigation")
    @JsonProperty(value="allowAgentNavigation")
    public Boolean getAllowAgentNavigation() {
        return this.allowAgentNavigation;
    }

    public void setAllowAgentNavigation(Boolean allowAgentNavigation) {
        this.allowAgentNavigation = allowAgentNavigation;
    }

    public CobrowseSettings maskSelectors(List<String> maskSelectors) {
        this.maskSelectors = maskSelectors;
        return this;
    }

    @ApiModelProperty(example="null", value="Mask patterns that will apply to pages being shared")
    @JsonProperty(value="maskSelectors")
    public List<String> getMaskSelectors() {
        return this.maskSelectors;
    }

    public void setMaskSelectors(List<String> maskSelectors) {
        this.maskSelectors = maskSelectors;
    }

    public CobrowseSettings channels(List<ChannelsEnum> channels) {
        this.channels = channels;
        return this;
    }

    @ApiModelProperty(example="null", value="Cobrowse channels for web messenger")
    @JsonProperty(value="channels")
    public List<ChannelsEnum> getChannels() {
        return this.channels;
    }

    public void setChannels(List<ChannelsEnum> channels) {
        this.channels = channels;
    }

    public CobrowseSettings readonlySelectors(List<String> readonlySelectors) {
        this.readonlySelectors = readonlySelectors;
        return this;
    }

    @ApiModelProperty(example="null", value="Readonly patterns that will apply to pages being shared")
    @JsonProperty(value="readonlySelectors")
    public List<String> getReadonlySelectors() {
        return this.readonlySelectors;
    }

    public void setReadonlySelectors(List<String> readonlySelectors) {
        this.readonlySelectors = readonlySelectors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CobrowseSettings cobrowseSettings = (CobrowseSettings)o;
        return Objects.equals(this.enabled, cobrowseSettings.enabled) && Objects.equals(this.allowAgentControl, cobrowseSettings.allowAgentControl) && Objects.equals(this.allowAgentNavigation, cobrowseSettings.allowAgentNavigation) && Objects.equals(this.maskSelectors, cobrowseSettings.maskSelectors) && Objects.equals(this.channels, cobrowseSettings.channels) && Objects.equals(this.readonlySelectors, cobrowseSettings.readonlySelectors);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.allowAgentControl, this.allowAgentNavigation, this.maskSelectors, this.channels, this.readonlySelectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CobrowseSettings {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    allowAgentControl: ").append(this.toIndentedString(this.allowAgentControl)).append("\n");
        sb.append("    allowAgentNavigation: ").append(this.toIndentedString(this.allowAgentNavigation)).append("\n");
        sb.append("    maskSelectors: ").append(this.toIndentedString(this.maskSelectors)).append("\n");
        sb.append("    channels: ").append(this.toIndentedString(this.channels)).append("\n");
        sb.append("    readonlySelectors: ").append(this.toIndentedString(this.readonlySelectors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ChannelsEnumDeserializer.class)
    public static enum ChannelsEnum {
        WEBMESSAGING("Webmessaging"),
        VOICE("Voice");

        private String value;

        private ChannelsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ChannelsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ChannelsEnum value : ChannelsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ChannelsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ChannelsEnumDeserializer
    extends StdDeserializer<ChannelsEnum> {
        public ChannelsEnumDeserializer() {
            super(ChannelsEnumDeserializer.class);
        }

        public ChannelsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ChannelsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

