/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.LearningAssignmentExternalUpdate;
import java.util.HashMap;
import java.util.Map;

public class PatchLearningModuleUserAssignmentsRequest {
    private String moduleId;
    private String userId;
    private LearningAssignmentExternalUpdate body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public PatchLearningModuleUserAssignmentsRequest withModuleId(String moduleId) {
        this.setModuleId(moduleId);
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PatchLearningModuleUserAssignmentsRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public LearningAssignmentExternalUpdate getBody() {
        return this.body;
    }

    public void setBody(LearningAssignmentExternalUpdate body) {
        this.body = body;
    }

    public PatchLearningModuleUserAssignmentsRequest withBody(LearningAssignmentExternalUpdate body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchLearningModuleUserAssignmentsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<LearningAssignmentExternalUpdate> withHttpInfo() {
        if (this.moduleId == null) {
            throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for PatchLearningModuleUserAssignmentsRequest.");
        }
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchLearningModuleUserAssignmentsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchLearningModuleUserAssignmentsRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/learning/modules/{moduleId}/users/{userId}/assignments").withPathParameter("moduleId", this.moduleId).withPathParameter("userId", this.userId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String moduleId, String userId, LearningAssignmentExternalUpdate body) {
        return new Builder().withRequiredParams(moduleId, userId, body);
    }

    public static class Builder {
        private final PatchLearningModuleUserAssignmentsRequest request = new PatchLearningModuleUserAssignmentsRequest();

        private Builder() {
        }

        public Builder withModuleId(String moduleId) {
            this.request.setModuleId(moduleId);
            return this;
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(LearningAssignmentExternalUpdate body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String moduleId, String userId, LearningAssignmentExternalUpdate body) {
            this.request.setModuleId(moduleId);
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PatchLearningModuleUserAssignmentsRequest build() {
            if (this.request.moduleId == null) {
                throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for PatchLearningModuleUserAssignmentsRequest.");
            }
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchLearningModuleUserAssignmentsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchLearningModuleUserAssignmentsRequest.");
            }
            return this.request;
        }
    }
}

