/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.MessagingInitialConfiguration;
import com.mypurecloud.sdk.v2.model.SourceConfiguration;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class MessagingExternalEstablishedEvent
implements Serializable {
    private String eventId = null;
    private Date eventDateTime = null;
    private String conversationId = null;
    private String communicationId = null;
    private String displayName = null;
    private MessagingInitialConfiguration initialConfiguration = null;
    private SourceConfiguration sourceConfiguration = null;

    public MessagingExternalEstablishedEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique (V4 UUID) eventId for this event")
    @JsonProperty(value="eventId")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public MessagingExternalEstablishedEvent eventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A Date Time representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDateTime")
    public Date getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
    }

    public MessagingExternalEstablishedEvent conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public MessagingExternalEstablishedEvent communicationId(String communicationId) {
        this.communicationId = communicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this communication.")
    @JsonProperty(value="communicationId")
    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public MessagingExternalEstablishedEvent displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", value="A name for the participant if it is available for this conversation.")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public MessagingExternalEstablishedEvent initialConfiguration(MessagingInitialConfiguration initialConfiguration) {
        this.initialConfiguration = initialConfiguration;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Metadata about this communication.")
    @JsonProperty(value="initialConfiguration")
    public MessagingInitialConfiguration getInitialConfiguration() {
        return this.initialConfiguration;
    }

    public void setInitialConfiguration(MessagingInitialConfiguration initialConfiguration) {
        this.initialConfiguration = initialConfiguration;
    }

    public MessagingExternalEstablishedEvent sourceConfiguration(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Metadata about the source of this communication's interaction.")
    @JsonProperty(value="sourceConfiguration")
    public SourceConfiguration getSourceConfiguration() {
        return this.sourceConfiguration;
    }

    public void setSourceConfiguration(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingExternalEstablishedEvent messagingExternalEstablishedEvent = (MessagingExternalEstablishedEvent)o;
        return Objects.equals(this.eventId, messagingExternalEstablishedEvent.eventId) && Objects.equals(this.eventDateTime, messagingExternalEstablishedEvent.eventDateTime) && Objects.equals(this.conversationId, messagingExternalEstablishedEvent.conversationId) && Objects.equals(this.communicationId, messagingExternalEstablishedEvent.communicationId) && Objects.equals(this.displayName, messagingExternalEstablishedEvent.displayName) && Objects.equals(this.initialConfiguration, messagingExternalEstablishedEvent.initialConfiguration) && Objects.equals(this.sourceConfiguration, messagingExternalEstablishedEvent.sourceConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.eventDateTime, this.conversationId, this.communicationId, this.displayName, this.initialConfiguration, this.sourceConfiguration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagingExternalEstablishedEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventDateTime: ").append(this.toIndentedString(this.eventDateTime)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    communicationId: ").append(this.toIndentedString(this.communicationId)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    initialConfiguration: ").append(this.toIndentedString(this.initialConfiguration)).append("\n");
        sb.append("    sourceConfiguration: ").append(this.toIndentedString(this.sourceConfiguration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

