/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class MessagingInitialConfiguration
implements Serializable {
    private String toAddress = null;
    private String fromAddress = null;
    private MessageTypeEnum messageType = null;
    private Boolean held = null;
    private Boolean alerting = null;
    private Boolean inbound = null;
    private String invitedBy = null;
    private Map<String, String> additionalInfo = null;

    public MessagingInitialConfiguration toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Address for the participant on receiving side of the message conversation. If the address is a phone number, E.164 format is recommended.")
    @JsonProperty(value="toAddress")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public MessagingInitialConfiguration fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Address for the participant on the sending side of the message conversation. If the address is a phone number, E.164 format is recommended.")
    @JsonProperty(value="fromAddress")
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public MessagingInitialConfiguration messageType(MessageTypeEnum messageType) {
        this.messageType = messageType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of message platform from which the message originated.")
    @JsonProperty(value="messageType")
    public MessageTypeEnum getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageTypeEnum messageType) {
        this.messageType = messageType;
    }

    public MessagingInitialConfiguration held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates that this communication's initial state is held.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public MessagingInitialConfiguration alerting(Boolean alerting) {
        this.alerting = alerting;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates that this communication's initial state is alerting. If false, the communication started in a connected state.")
    @JsonProperty(value="alerting")
    public Boolean getAlerting() {
        return this.alerting;
    }

    public void setAlerting(Boolean alerting) {
        this.alerting = alerting;
    }

    public MessagingInitialConfiguration inbound(Boolean inbound) {
        this.inbound = inbound;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the direction of this communication with respect to the contact center. `true` means the communication is INBOUND. `false` means the communication is OUTBOUND.")
    @JsonProperty(value="inbound")
    public Boolean getInbound() {
        return this.inbound;
    }

    public void setInbound(Boolean inbound) {
        this.inbound = inbound;
    }

    public MessagingInitialConfiguration invitedBy(String invitedBy) {
        this.invitedBy = invitedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the communication (the \"peer\") that \"invited\" this communication, if this occurred.")
    @JsonProperty(value="invitedBy")
    public String getInvitedBy() {
        return this.invitedBy;
    }

    public void setInvitedBy(String invitedBy) {
        this.invitedBy = invitedBy;
    }

    public MessagingInitialConfiguration additionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional metadata about this session which should be recorded by the platform but which will not be indexed or searchable. Primarily for diagnostic value. Any information that needs to be accessible through other components like Analytics should be moved to dedicated fields.")
    @JsonProperty(value="additionalInfo")
    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingInitialConfiguration messagingInitialConfiguration = (MessagingInitialConfiguration)o;
        return Objects.equals(this.toAddress, messagingInitialConfiguration.toAddress) && Objects.equals(this.fromAddress, messagingInitialConfiguration.fromAddress) && Objects.equals((Object)this.messageType, (Object)messagingInitialConfiguration.messageType) && Objects.equals(this.held, messagingInitialConfiguration.held) && Objects.equals(this.alerting, messagingInitialConfiguration.alerting) && Objects.equals(this.inbound, messagingInitialConfiguration.inbound) && Objects.equals(this.invitedBy, messagingInitialConfiguration.invitedBy) && Objects.equals(this.additionalInfo, messagingInitialConfiguration.additionalInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.toAddress, this.fromAddress, this.messageType, this.held, this.alerting, this.inbound, this.invitedBy, this.additionalInfo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagingInitialConfiguration {\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    messageType: ").append(this.toIndentedString((Object)this.messageType)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    alerting: ").append(this.toIndentedString(this.alerting)).append("\n");
        sb.append("    inbound: ").append(this.toIndentedString(this.inbound)).append("\n");
        sb.append("    invitedBy: ").append(this.toIndentedString(this.invitedBy)).append("\n");
        sb.append("    additionalInfo: ").append(this.toIndentedString(this.additionalInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MessageTypeEnumDeserializer.class)
    public static enum MessageTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SMS("Sms"),
        TWITTER("Twitter"),
        FACEBOOK("Facebook"),
        LINE("Line"),
        WHATSAPP("WhatsApp"),
        WEBMESSAGE("WebMessage"),
        OPEN("Open"),
        INSTAGRAM("Instagram"),
        UNKNOWN("Unknown");

        private String value;

        private MessageTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessageTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessageTypeEnum value : MessageTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessageTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MessageTypeEnumDeserializer
    extends StdDeserializer<MessageTypeEnum> {
        public MessageTypeEnumDeserializer() {
            super(MessageTypeEnumDeserializer.class);
        }

        public MessageTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MessageTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

