/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.JourneyViewElementAttributes;
import com.mypurecloud.sdk.v2.model.JourneyViewElementFilter;
import com.mypurecloud.sdk.v2.model.JourneyViewLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An element within a journey view")
public class JourneyViewElement
implements Serializable {
    private String id = null;
    private String name = null;
    private JourneyViewElementAttributes attributes = null;
    private JourneyViewElementFilter filter = null;
    private List<JourneyViewLink> followedBy = new ArrayList<JourneyViewLink>();

    public JourneyViewElement id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The unique identifier of the element within the elements list")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JourneyViewElement name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The unique name of the element within the view")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JourneyViewElement attributes(JourneyViewElementAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Required attributes of the element")
    @JsonProperty(value="attributes")
    public JourneyViewElementAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(JourneyViewElementAttributes attributes) {
        this.attributes = attributes;
    }

    public JourneyViewElement filter(JourneyViewElementFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", value="Any filters applied to this element")
    @JsonProperty(value="filter")
    public JourneyViewElementFilter getFilter() {
        return this.filter;
    }

    public void setFilter(JourneyViewElementFilter filter) {
        this.filter = filter;
    }

    public JourneyViewElement followedBy(List<JourneyViewLink> followedBy) {
        this.followedBy = followedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of JourneyViewLink objects, listing the elements downstream of this element")
    @JsonProperty(value="followedBy")
    public List<JourneyViewLink> getFollowedBy() {
        return this.followedBy;
    }

    public void setFollowedBy(List<JourneyViewLink> followedBy) {
        this.followedBy = followedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyViewElement journeyViewElement = (JourneyViewElement)o;
        return Objects.equals(this.id, journeyViewElement.id) && Objects.equals(this.name, journeyViewElement.name) && Objects.equals(this.attributes, journeyViewElement.attributes) && Objects.equals(this.filter, journeyViewElement.filter) && Objects.equals(this.followedBy, journeyViewElement.followedBy);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.attributes, this.filter, this.followedBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyViewElement {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    followedBy: ").append(this.toIndentedString(this.followedBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

