/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WorkitemStatusCreate
implements Serializable {
    private String name = null;
    private CategoryEnum category = null;
    private List<String> destinationStatusIds = new ArrayList<String>();
    private String description = null;
    private String defaultDestinationStatusId = null;
    private Integer statusTransitionDelaySeconds = null;
    private String statusTransitionTime = null;

    public WorkitemStatusCreate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Status. Valid length between 3 and 256 characters.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkitemStatusCreate category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Category of the Status.")
    @JsonProperty(value="category")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public WorkitemStatusCreate destinationStatusIds(List<String> destinationStatusIds) {
        this.destinationStatusIds = destinationStatusIds;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of destination Statuses where a Workitem with this Status can transition to. If the list is empty Workitems with this Status can transition to all other Statuses defined on the Worktype. A Status can have a maximum of 24 destinations.")
    @JsonProperty(value="destinationStatusIds")
    public List<String> getDestinationStatusIds() {
        return this.destinationStatusIds;
    }

    public void setDestinationStatusIds(List<String> destinationStatusIds) {
        this.destinationStatusIds = destinationStatusIds;
    }

    public WorkitemStatusCreate description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the Status. Maximum length of 4096 characters.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkitemStatusCreate defaultDestinationStatusId(String defaultDestinationStatusId) {
        this.defaultDestinationStatusId = defaultDestinationStatusId;
        return this;
    }

    @ApiModelProperty(example="null", value="Default destination status to which this Status will transition to if auto status transition enabled.")
    @JsonProperty(value="defaultDestinationStatusId")
    public String getDefaultDestinationStatusId() {
        return this.defaultDestinationStatusId;
    }

    public void setDefaultDestinationStatusId(String defaultDestinationStatusId) {
        this.defaultDestinationStatusId = defaultDestinationStatusId;
    }

    public WorkitemStatusCreate statusTransitionDelaySeconds(Integer statusTransitionDelaySeconds) {
        this.statusTransitionDelaySeconds = statusTransitionDelaySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Delay in seconds for auto status transition. Required if defaultDestinationStatusId is provided.")
    @JsonProperty(value="statusTransitionDelaySeconds")
    public Integer getStatusTransitionDelaySeconds() {
        return this.statusTransitionDelaySeconds;
    }

    public void setStatusTransitionDelaySeconds(Integer statusTransitionDelaySeconds) {
        this.statusTransitionDelaySeconds = statusTransitionDelaySeconds;
    }

    public WorkitemStatusCreate statusTransitionTime(String statusTransitionTime) {
        this.statusTransitionTime = statusTransitionTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Time is represented as an ISO-8601 string without a timezone. For example: HH:mm:ss.SSS")
    @JsonProperty(value="statusTransitionTime")
    public String getStatusTransitionTime() {
        return this.statusTransitionTime;
    }

    public void setStatusTransitionTime(String statusTransitionTime) {
        this.statusTransitionTime = statusTransitionTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemStatusCreate workitemStatusCreate = (WorkitemStatusCreate)o;
        return Objects.equals(this.name, workitemStatusCreate.name) && Objects.equals((Object)this.category, (Object)workitemStatusCreate.category) && Objects.equals(this.destinationStatusIds, workitemStatusCreate.destinationStatusIds) && Objects.equals(this.description, workitemStatusCreate.description) && Objects.equals(this.defaultDestinationStatusId, workitemStatusCreate.defaultDestinationStatusId) && Objects.equals(this.statusTransitionDelaySeconds, workitemStatusCreate.statusTransitionDelaySeconds) && Objects.equals(this.statusTransitionTime, workitemStatusCreate.statusTransitionTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.category, this.destinationStatusIds, this.description, this.defaultDestinationStatusId, this.statusTransitionDelaySeconds, this.statusTransitionTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemStatusCreate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    destinationStatusIds: ").append(this.toIndentedString(this.destinationStatusIds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    defaultDestinationStatusId: ").append(this.toIndentedString(this.defaultDestinationStatusId)).append("\n");
        sb.append("    statusTransitionDelaySeconds: ").append(this.toIndentedString(this.statusTransitionDelaySeconds)).append("\n");
        sb.append("    statusTransitionTime: ").append(this.toIndentedString(this.statusTransitionTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CategoryEnumDeserializer.class)
    public static enum CategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OPEN("Open"),
        INPROGRESS("InProgress"),
        WAITING("Waiting"),
        CLOSED("Closed"),
        UNKNOWN("Unknown");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CategoryEnum value : CategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CategoryEnumDeserializer
    extends StdDeserializer<CategoryEnum> {
        public CategoryEnumDeserializer() {
            super(CategoryEnumDeserializer.class);
        }

        public CategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

