/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TimeOffBalanceResponse
implements Serializable {
    private String activityCodeId = null;
    private String hrisTimeOffTypeId = null;
    private String hrisTimeOffTypeSecondaryId = null;
    private LocalDate startDate = null;
    private List<Integer> balanceMinutesPerDay = new ArrayList<Integer>();

    public TimeOffBalanceResponse activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID for activity code associated with time off balance")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public TimeOffBalanceResponse hrisTimeOffTypeId(String hrisTimeOffTypeId) {
        this.hrisTimeOffTypeId = hrisTimeOffTypeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the time off type configured in HRIS integration")
    @JsonProperty(value="hrisTimeOffTypeId")
    public String getHrisTimeOffTypeId() {
        return this.hrisTimeOffTypeId;
    }

    public void setHrisTimeOffTypeId(String hrisTimeOffTypeId) {
        this.hrisTimeOffTypeId = hrisTimeOffTypeId;
    }

    public TimeOffBalanceResponse hrisTimeOffTypeSecondaryId(String hrisTimeOffTypeSecondaryId) {
        this.hrisTimeOffTypeSecondaryId = hrisTimeOffTypeSecondaryId;
        return this;
    }

    @ApiModelProperty(example="null", value="The secondary ID of the time off type configured in HRIS integration")
    @JsonProperty(value="hrisTimeOffTypeSecondaryId")
    public String getHrisTimeOffTypeSecondaryId() {
        return this.hrisTimeOffTypeSecondaryId;
    }

    public void setHrisTimeOffTypeSecondaryId(String hrisTimeOffTypeSecondaryId) {
        this.hrisTimeOffTypeSecondaryId = hrisTimeOffTypeSecondaryId;
    }

    public TimeOffBalanceResponse startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The Start date of the requested date range. The end date is determined by the size of interval list. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="startDate")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public TimeOffBalanceResponse balanceMinutesPerDay(List<Integer> balanceMinutesPerDay) {
        this.balanceMinutesPerDay = balanceMinutesPerDay;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of available time off balance values in minutes for each day")
    @JsonProperty(value="balanceMinutesPerDay")
    public List<Integer> getBalanceMinutesPerDay() {
        return this.balanceMinutesPerDay;
    }

    public void setBalanceMinutesPerDay(List<Integer> balanceMinutesPerDay) {
        this.balanceMinutesPerDay = balanceMinutesPerDay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeOffBalanceResponse timeOffBalanceResponse = (TimeOffBalanceResponse)o;
        return Objects.equals(this.activityCodeId, timeOffBalanceResponse.activityCodeId) && Objects.equals(this.hrisTimeOffTypeId, timeOffBalanceResponse.hrisTimeOffTypeId) && Objects.equals(this.hrisTimeOffTypeSecondaryId, timeOffBalanceResponse.hrisTimeOffTypeSecondaryId) && Objects.equals(this.startDate, timeOffBalanceResponse.startDate) && Objects.equals(this.balanceMinutesPerDay, timeOffBalanceResponse.balanceMinutesPerDay);
    }

    public int hashCode() {
        return Objects.hash(this.activityCodeId, this.hrisTimeOffTypeId, this.hrisTimeOffTypeSecondaryId, this.startDate, this.balanceMinutesPerDay);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeOffBalanceResponse {\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    hrisTimeOffTypeId: ").append(this.toIndentedString(this.hrisTimeOffTypeId)).append("\n");
        sb.append("    hrisTimeOffTypeSecondaryId: ").append(this.toIndentedString(this.hrisTimeOffTypeSecondaryId)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    balanceMinutesPerDay: ").append(this.toIndentedString(this.balanceMinutesPerDay)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

