/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetFlowsInstanceRequest {
    private String instanceId;
    private String expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public GetFlowsInstanceRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public GetFlowsInstanceRequest withExpand(String expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetFlowsInstanceRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.instanceId == null) {
            throw new IllegalStateException("Missing the required parameter 'instanceId' when building request for GetFlowsInstanceRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/flows/instances/{instanceId}").withPathParameter("instanceId", this.instanceId).withQueryParameters("expand", "", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String instanceId) {
        return new Builder().withRequiredParams(instanceId);
    }

    public static class Builder {
        private final GetFlowsInstanceRequest request = new GetFlowsInstanceRequest();

        private Builder() {
        }

        public Builder withInstanceId(String instanceId) {
            this.request.setInstanceId(instanceId);
            return this;
        }

        public Builder withExpand(String expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpand(expandValues expand) {
            this.request.setExpand(expand.toString());
            return this;
        }

        public Builder withRequiredParams(String instanceId) {
            this.request.setInstanceId(instanceId);
            return this;
        }

        public GetFlowsInstanceRequest build() {
            if (this.request.instanceId == null) {
                throw new IllegalStateException("Missing the required parameter 'instanceId' when building request for GetFlowsInstanceRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        BOTS("bots"),
        DATAACTIONS("dataActions");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

