/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PermissionDetails
implements Serializable {
    private TypeEnum type = null;
    private List<String> permissions = new ArrayList<String>();
    private Boolean allowsCurrentUser = null;
    private Boolean enforced = null;

    public PermissionDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of permission requirement")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PermissionDetails permissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    @ApiModelProperty(example="null", value="List of required permissions")
    @JsonProperty(value="permissions")
    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public PermissionDetails allowsCurrentUser(Boolean allowsCurrentUser) {
        this.allowsCurrentUser = allowsCurrentUser;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the current user can subscribe, when division permissions are otherwise required")
    @JsonProperty(value="allowsCurrentUser")
    public Boolean getAllowsCurrentUser() {
        return this.allowsCurrentUser;
    }

    public void setAllowsCurrentUser(Boolean allowsCurrentUser) {
        this.allowsCurrentUser = allowsCurrentUser;
    }

    public PermissionDetails enforced(Boolean enforced) {
        this.enforced = enforced;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not this permission requirement is enforced")
    @JsonProperty(value="enforced")
    public Boolean getEnforced() {
        return this.enforced;
    }

    public void setEnforced(Boolean enforced) {
        this.enforced = enforced;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionDetails permissionDetails = (PermissionDetails)o;
        return Objects.equals((Object)this.type, (Object)permissionDetails.type) && Objects.equals(this.permissions, permissionDetails.permissions) && Objects.equals(this.allowsCurrentUser, permissionDetails.allowsCurrentUser) && Objects.equals(this.enforced, permissionDetails.enforced);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.permissions, this.allowsCurrentUser, this.enforced});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionDetails {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    allowsCurrentUser: ").append(this.toIndentedString(this.allowsCurrentUser)).append("\n");
        sb.append("    enforced: ").append(this.toIndentedString(this.enforced)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        REQUIRESCURRENTUSER("requiresCurrentUser"),
        REQUIRESPERMISSIONS("requiresPermissions"),
        REQUIRESDIVISIONPERMISSIONS("requiresDivisionPermissions"),
        REQUIRESANYDIVISIONPERMISSIONS("requiresAnyDivisionPermissions"),
        REQUIRESUSERBECONVERSATIONPARTICIPANT("requiresUserBeConversationParticipant");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

