/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.LearningAssignmentUpdate;
import java.util.HashMap;
import java.util.Map;

public class PatchLearningAssignmentRequest {
    private String assignmentId;
    private LearningAssignmentUpdate body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAssignmentId() {
        return this.assignmentId;
    }

    public void setAssignmentId(String assignmentId) {
        this.assignmentId = assignmentId;
    }

    public PatchLearningAssignmentRequest withAssignmentId(String assignmentId) {
        this.setAssignmentId(assignmentId);
        return this;
    }

    public LearningAssignmentUpdate getBody() {
        return this.body;
    }

    public void setBody(LearningAssignmentUpdate body) {
        this.body = body;
    }

    public PatchLearningAssignmentRequest withBody(LearningAssignmentUpdate body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchLearningAssignmentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<LearningAssignmentUpdate> withHttpInfo() {
        if (this.assignmentId == null) {
            throw new IllegalStateException("Missing the required parameter 'assignmentId' when building request for PatchLearningAssignmentRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/learning/assignments/{assignmentId}").withPathParameter("assignmentId", this.assignmentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String assignmentId) {
        return new Builder().withRequiredParams(assignmentId);
    }

    public static class Builder {
        private final PatchLearningAssignmentRequest request = new PatchLearningAssignmentRequest();

        private Builder() {
        }

        public Builder withAssignmentId(String assignmentId) {
            this.request.setAssignmentId(assignmentId);
            return this;
        }

        public Builder withBody(LearningAssignmentUpdate body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String assignmentId) {
            this.request.setAssignmentId(assignmentId);
            return this;
        }

        public PatchLearningAssignmentRequest build() {
            if (this.request.assignmentId == null) {
                throw new IllegalStateException("Missing the required parameter 'assignmentId' when building request for PatchLearningAssignmentRequest.");
            }
            return this.request;
        }
    }
}

