/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.SetWrapperString;
import com.mypurecloud.sdk.v2.model.ValueWrapperHrisTimeOffType;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class UpdateTimeOffPlanRequest
implements Serializable {
    private String name = null;
    private SetWrapperString activityCodeIds = null;
    private SetWrapperString timeOffLimitIds = null;
    private AutoApprovalRuleEnum autoApprovalRule = null;
    private Integer daysBeforeStartToExpireFromWaitlist = null;
    private ValueWrapperHrisTimeOffType hrisTimeOffType = null;
    private Boolean active = null;
    private WfmVersionedEntityMetadata metadata = null;

    public UpdateTimeOffPlanRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of this time off plan.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateTimeOffPlanRequest activityCodeIds(SetWrapperString activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The set of activity code IDs to associate with this time off plan.")
    @JsonProperty(value="activityCodeIds")
    public SetWrapperString getActivityCodeIds() {
        return this.activityCodeIds;
    }

    public void setActivityCodeIds(SetWrapperString activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
    }

    public UpdateTimeOffPlanRequest timeOffLimitIds(SetWrapperString timeOffLimitIds) {
        this.timeOffLimitIds = timeOffLimitIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The set of time off limit IDs to associate with this time off plan.")
    @JsonProperty(value="timeOffLimitIds")
    public SetWrapperString getTimeOffLimitIds() {
        return this.timeOffLimitIds;
    }

    public void setTimeOffLimitIds(SetWrapperString timeOffLimitIds) {
        this.timeOffLimitIds = timeOffLimitIds;
    }

    public UpdateTimeOffPlanRequest autoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
        return this;
    }

    @ApiModelProperty(example="null", value="Auto approval rule for the time off plan.")
    @JsonProperty(value="autoApprovalRule")
    public AutoApprovalRuleEnum getAutoApprovalRule() {
        return this.autoApprovalRule;
    }

    public void setAutoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
    }

    public UpdateTimeOffPlanRequest daysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of days before the time off request start date for when the request will be expired from the waitlist.")
    @JsonProperty(value="daysBeforeStartToExpireFromWaitlist")
    public Integer getDaysBeforeStartToExpireFromWaitlist() {
        return this.daysBeforeStartToExpireFromWaitlist;
    }

    public void setDaysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
    }

    public UpdateTimeOffPlanRequest hrisTimeOffType(ValueWrapperHrisTimeOffType hrisTimeOffType) {
        this.hrisTimeOffType = hrisTimeOffType;
        return this;
    }

    @ApiModelProperty(example="null", value="Time off type, if this time off plan is associated with the integration.")
    @JsonProperty(value="hrisTimeOffType")
    public ValueWrapperHrisTimeOffType getHrisTimeOffType() {
        return this.hrisTimeOffType;
    }

    public void setHrisTimeOffType(ValueWrapperHrisTimeOffType hrisTimeOffType) {
        this.hrisTimeOffType = hrisTimeOffType;
    }

    public UpdateTimeOffPlanRequest active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this time off plan should be used by agents.")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public UpdateTimeOffPlanRequest metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version metadata for the time off plan")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateTimeOffPlanRequest updateTimeOffPlanRequest = (UpdateTimeOffPlanRequest)o;
        return Objects.equals(this.name, updateTimeOffPlanRequest.name) && Objects.equals(this.activityCodeIds, updateTimeOffPlanRequest.activityCodeIds) && Objects.equals(this.timeOffLimitIds, updateTimeOffPlanRequest.timeOffLimitIds) && Objects.equals((Object)this.autoApprovalRule, (Object)updateTimeOffPlanRequest.autoApprovalRule) && Objects.equals(this.daysBeforeStartToExpireFromWaitlist, updateTimeOffPlanRequest.daysBeforeStartToExpireFromWaitlist) && Objects.equals(this.hrisTimeOffType, updateTimeOffPlanRequest.hrisTimeOffType) && Objects.equals(this.active, updateTimeOffPlanRequest.active) && Objects.equals(this.metadata, updateTimeOffPlanRequest.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.activityCodeIds, this.timeOffLimitIds, this.autoApprovalRule, this.daysBeforeStartToExpireFromWaitlist, this.hrisTimeOffType, this.active, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateTimeOffPlanRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    activityCodeIds: ").append(this.toIndentedString(this.activityCodeIds)).append("\n");
        sb.append("    timeOffLimitIds: ").append(this.toIndentedString(this.timeOffLimitIds)).append("\n");
        sb.append("    autoApprovalRule: ").append(this.toIndentedString((Object)this.autoApprovalRule)).append("\n");
        sb.append("    daysBeforeStartToExpireFromWaitlist: ").append(this.toIndentedString(this.daysBeforeStartToExpireFromWaitlist)).append("\n");
        sb.append("    hrisTimeOffType: ").append(this.toIndentedString(this.hrisTimeOffType)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AutoApprovalRuleEnumDeserializer.class)
    public static enum AutoApprovalRuleEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NEVER("Never"),
        ALWAYS("Always"),
        CHECKLIMITS("CheckLimits");

        private String value;

        private AutoApprovalRuleEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AutoApprovalRuleEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AutoApprovalRuleEnum value : AutoApprovalRuleEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AutoApprovalRuleEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AutoApprovalRuleEnumDeserializer
    extends StdDeserializer<AutoApprovalRuleEnum> {
        public AutoApprovalRuleEnumDeserializer() {
            super(AutoApprovalRuleEnumDeserializer.class);
        }

        public AutoApprovalRuleEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AutoApprovalRuleEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

