/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.extensions.notifications;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.NotificationsApi;
import com.mypurecloud.sdk.v2.api.request.PostNotificationsChannelsRequest;
import com.mypurecloud.sdk.v2.extensions.notifications.NotificationEvent;
import com.mypurecloud.sdk.v2.extensions.notifications.NotificationListener;
import com.mypurecloud.sdk.v2.extensions.notifications.WebSocketListener;
import com.mypurecloud.sdk.v2.model.Channel;
import com.mypurecloud.sdk.v2.model.ChannelTopic;
import com.mypurecloud.sdk.v2.model.ChannelTopicEntityListing;
import com.mypurecloud.sdk.v2.model.SystemMessageSystemMessage;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationHandler.class);
    private NotificationsApi notificationsApi = new NotificationsApi();
    private WebSocket webSocket;
    private Channel channel;
    private Map<String, NotificationListener<?>> typeMap = new HashMap();
    private WebSocketListener webSocketListener = null;
    private ObjectMapper objectMapper = null;

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public NotificationHandler() throws IOException, ApiException, WebSocketException {
        this(Builder.standard());
    }

    private NotificationHandler(Builder builder) throws IOException, ApiException, WebSocketException {
        this.notificationsApi = builder.notificationsApi != null ? builder.notificationsApi : (builder.apiClient != null ? new NotificationsApi(builder.apiClient) : new NotificationsApi());
        this.objectMapper = builder.objectMapper != null ? builder.objectMapper : (builder.apiClient != null ? builder.apiClient.getObjectMapper() : Configuration.getDefaultApiClient().getObjectMapper());
        this.channel = builder.channel == null ? this.notificationsApi.postNotificationsChannels(PostNotificationsChannelsRequest.builder().build()) : builder.channel;
        this.addSubscriptions(builder.notificationListeners);
        this.addHandlerNoSubscribe(new SocketClosingHandler());
        this.setWebSocketListener(builder.webSocketListener);
        WebSocketFactory factory = new WebSocketFactory();
        if (builder.proxyHost != null) {
            factory.getProxySettings().setServer(builder.proxyHost);
        }
        this.webSocket = factory.createSocket(this.channel.getConnectUri()).addListener((com.neovisionaries.ws.client.WebSocketListener)new WebSocketAdapter(){

            public void onStateChanged(WebSocket websocket, WebSocketState newState) throws Exception {
                if (NotificationHandler.this.webSocketListener != null) {
                    NotificationHandler.this.webSocketListener.onStateChanged(newState);
                }
            }

            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                if (NotificationHandler.this.webSocketListener != null) {
                    NotificationHandler.this.webSocketListener.onConnected();
                }
            }

            public void onConnectError(WebSocket websocket, WebSocketException exception) throws Exception {
                if (NotificationHandler.this.webSocketListener != null) {
                    NotificationHandler.this.webSocketListener.onConnectError(exception);
                }
            }

            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                if (NotificationHandler.this.webSocketListener != null) {
                    NotificationHandler.this.webSocketListener.onDisconnected(closedByServer);
                }
            }

            public void onTextMessage(WebSocket websocket, String message) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("---WEBSOCKET MESSAGE---\n" + message);
                    }
                    JavaType genericEventType = NotificationHandler.this.objectMapper.getTypeFactory().constructParametricType(NotificationEvent.class, new Class[]{Object.class});
                    NotificationEvent genericEventData = (NotificationEvent)NotificationHandler.this.objectMapper.readValue(message, genericEventType);
                    NotificationListener specificType = (NotificationListener)NotificationHandler.this.typeMap.get(genericEventData.getTopicName());
                    if (specificType != null) {
                        JavaType specificEventType = NotificationHandler.this.objectMapper.getTypeFactory().constructParametricType(NotificationEvent.class, new Class[]{specificType.getEventBodyClass()});
                        NotificationEvent notificationEvent = (NotificationEvent)NotificationHandler.this.objectMapper.readValue(message, specificEventType);
                        notificationEvent.setEventBodyRaw(message);
                        specificType.onEvent(notificationEvent);
                    } else if (NotificationHandler.this.webSocketListener != null) {
                        NotificationHandler.this.webSocketListener.onUnhandledEvent(message);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                }
            }

            public void onError(WebSocket websocket, WebSocketException cause) throws Exception {
                if (NotificationHandler.this.webSocketListener != null) {
                    NotificationHandler.this.webSocketListener.onError(cause);
                }
            }

            public void handleCallbackError(WebSocket websocket, Throwable cause) throws Exception {
                if (NotificationHandler.this.webSocketListener != null) {
                    NotificationHandler.this.webSocketListener.onCallbackError(cause);
                }
            }
        });
        if (builder.connectAsync != null) {
            this.connect(builder.connectAsync);
        }
    }

    public void sendPing() {
        this.webSocket.sendText("{\"message\":\"ping\"}");
    }

    public void setWebSocketListener(WebSocketListener webSocketListener) {
        this.webSocketListener = webSocketListener;
    }

    public <T> void addSubscription(NotificationListener<T> listener) throws IOException, ApiException {
        this.addSubscriptions(Collections.singletonList(listener));
    }

    public void addSubscriptions(List<NotificationListener<?>> listeners) throws IOException, ApiException {
        LinkedList<ChannelTopic> topics = new LinkedList<ChannelTopic>();
        for (NotificationListener<?> listener : listeners) {
            this.typeMap.put(listener.getTopic(), listener);
            if ("channel.metadata".equals(listener.getTopic()) || listener.getTopic().startsWith("v2.system")) continue;
            ChannelTopic channelTopic = new ChannelTopic();
            channelTopic.setId(listener.getTopic());
            topics.add(channelTopic);
        }
        this.notificationsApi.postNotificationsChannelSubscriptions(this.channel.getId(), topics, false);
    }

    public <T> void addHandlerNoSubscribe(NotificationListener<T> listener) {
        this.addHandlersNoSubscribe(Collections.singletonList(listener));
    }

    public void addHandlersNoSubscribe(List<NotificationListener<?>> listeners) {
        for (NotificationListener<?> listener : listeners) {
            this.typeMap.put(listener.getTopic(), listener);
        }
    }

    public void RemoveSubscription(String topic) throws IOException, ApiException {
        ChannelTopicEntityListing channels = this.notificationsApi.getNotificationsChannelSubscriptions(this.channel.getId());
        ChannelTopic match = null;
        for (ChannelTopic channelTopic : channels.getEntities()) {
            if (!channelTopic.getId().equalsIgnoreCase(topic)) continue;
            match = channelTopic;
            break;
        }
        if (match == null) {
            return;
        }
        channels.getEntities().remove(match);
        this.notificationsApi.putNotificationsChannelSubscriptions(this.channel.getId(), channels.getEntities(), false);
        this.typeMap.remove(topic);
    }

    public void RemoveAllSubscriptions() throws IOException, ApiException {
        this.notificationsApi.deleteNotificationsChannelSubscriptions(this.channel.getId());
        this.typeMap.clear();
    }

    public void connect(boolean async) throws WebSocketException {
        if (async) {
            this.webSocket.connectAsynchronously();
        } else {
            this.webSocket.connect();
        }
    }

    public void disconnect() {
        if (this.webSocket != null && this.webSocket.isOpen()) {
            this.webSocket.disconnect();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.disconnect();
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        super.finalize();
    }

    public static class Builder {
        private List<NotificationListener<?>> notificationListeners;
        private WebSocketListener webSocketListener;
        private Channel channel;
        private Boolean connectAsync;
        private ApiClient apiClient;
        private NotificationsApi notificationsApi;
        private ObjectMapper objectMapper;
        private String proxyHost;

        public static Builder standard() {
            Builder builder = new Builder();
            builder.notificationListeners = new ArrayList();
            builder.webSocketListener = null;
            builder.channel = null;
            builder.connectAsync = null;
            builder.apiClient = null;
            builder.notificationsApi = null;
            builder.objectMapper = null;
            builder.proxyHost = null;
            return builder;
        }

        public Builder withNotificationListener(NotificationListener<?> notificationListener) {
            this.notificationListeners.add(notificationListener);
            return this;
        }

        public Builder withNotificationListeners(List<NotificationListener<?>> notificationListeners) {
            this.notificationListeners.addAll(notificationListeners);
            return this;
        }

        public Builder withWebSocketListener(WebSocketListener webSocketListener) {
            this.webSocketListener = webSocketListener;
            return this;
        }

        public Builder withChannel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public Builder withAutoConnect(Boolean connectAsync) {
            this.connectAsync = connectAsync;
            return this;
        }

        public Builder withApiClient(ApiClient apiClient) {
            this.apiClient = apiClient;
            return this;
        }

        public Builder withNotificationsApi(NotificationsApi notificationsApi) {
            this.notificationsApi = notificationsApi;
            return this;
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder withProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public NotificationHandler build() throws IOException, ApiException, WebSocketException {
            return new NotificationHandler(this);
        }
    }

    private class SocketClosingHandler
    implements NotificationListener<SystemMessageSystemMessage> {
        private String topic = "v2.system.socket_closing";

        private SocketClosingHandler() {
        }

        @Override
        public String getTopic() {
            return this.topic;
        }

        @Override
        public Class<?> getEventBodyClass() {
            return SystemMessageSystemMessage.class;
        }

        @Override
        public void onEvent(NotificationEvent<?> event) {
            try {
                NotificationHandler.this.webSocket = NotificationHandler.this.webSocket.recreate();
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

