/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteMobiledeviceRequest;
import com.mypurecloud.sdk.v2.api.request.GetMobiledeviceRequest;
import com.mypurecloud.sdk.v2.api.request.GetMobiledevicesRequest;
import com.mypurecloud.sdk.v2.api.request.PostMobiledevicesRequest;
import com.mypurecloud.sdk.v2.api.request.PutMobiledeviceRequest;
import com.mypurecloud.sdk.v2.model.DirectoryUserDevicesListing;
import com.mypurecloud.sdk.v2.model.UserDevice;
import java.io.IOException;

public class MobileDevicesApi {
    private final ApiClient pcapiClient;

    public MobileDevicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MobileDevicesApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteMobiledevice(String deviceId) throws IOException, ApiException {
        this.deleteMobiledevice(this.createDeleteMobiledeviceRequest(deviceId));
    }

    public ApiResponse<Void> deleteMobiledeviceWithHttpInfo(String deviceId) throws IOException {
        return this.deleteMobiledevice(this.createDeleteMobiledeviceRequest(deviceId).withHttpInfo());
    }

    private DeleteMobiledeviceRequest createDeleteMobiledeviceRequest(String deviceId) {
        return DeleteMobiledeviceRequest.builder().withDeviceId(deviceId).build();
    }

    public void deleteMobiledevice(DeleteMobiledeviceRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteMobiledevice(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserDevice getMobiledevice(String deviceId) throws IOException, ApiException {
        return this.getMobiledevice(this.createGetMobiledeviceRequest(deviceId));
    }

    public ApiResponse<UserDevice> getMobiledeviceWithHttpInfo(String deviceId) throws IOException {
        return this.getMobiledevice(this.createGetMobiledeviceRequest(deviceId).withHttpInfo());
    }

    private GetMobiledeviceRequest createGetMobiledeviceRequest(String deviceId) {
        return GetMobiledeviceRequest.builder().withDeviceId(deviceId).build();
    }

    public UserDevice getMobiledevice(GetMobiledeviceRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserDevice> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserDevice>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserDevice> getMobiledevice(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserDevice>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DirectoryUserDevicesListing getMobiledevices(Integer pageSize, Integer pageNumber, String sortOrder) throws IOException, ApiException {
        return this.getMobiledevices(this.createGetMobiledevicesRequest(pageSize, pageNumber, sortOrder));
    }

    public ApiResponse<DirectoryUserDevicesListing> getMobiledevicesWithHttpInfo(Integer pageSize, Integer pageNumber, String sortOrder) throws IOException {
        return this.getMobiledevices(this.createGetMobiledevicesRequest(pageSize, pageNumber, sortOrder).withHttpInfo());
    }

    private GetMobiledevicesRequest createGetMobiledevicesRequest(Integer pageSize, Integer pageNumber, String sortOrder) {
        return GetMobiledevicesRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortOrder(sortOrder).build();
    }

    public DirectoryUserDevicesListing getMobiledevices(GetMobiledevicesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DirectoryUserDevicesListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DirectoryUserDevicesListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DirectoryUserDevicesListing> getMobiledevices(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DirectoryUserDevicesListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserDevice postMobiledevices(UserDevice body) throws IOException, ApiException {
        return this.postMobiledevices(this.createPostMobiledevicesRequest(body));
    }

    public ApiResponse<UserDevice> postMobiledevicesWithHttpInfo(UserDevice body) throws IOException {
        return this.postMobiledevices(this.createPostMobiledevicesRequest(body).withHttpInfo());
    }

    private PostMobiledevicesRequest createPostMobiledevicesRequest(UserDevice body) {
        return PostMobiledevicesRequest.builder().withBody(body).build();
    }

    public UserDevice postMobiledevices(PostMobiledevicesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserDevice> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserDevice>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserDevice> postMobiledevices(ApiRequest<UserDevice> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserDevice>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserDevice putMobiledevice(String deviceId, UserDevice body) throws IOException, ApiException {
        return this.putMobiledevice(this.createPutMobiledeviceRequest(deviceId, body));
    }

    public ApiResponse<UserDevice> putMobiledeviceWithHttpInfo(String deviceId, UserDevice body) throws IOException {
        return this.putMobiledevice(this.createPutMobiledeviceRequest(deviceId, body).withHttpInfo());
    }

    private PutMobiledeviceRequest createPutMobiledeviceRequest(String deviceId, UserDevice body) {
        return PutMobiledeviceRequest.builder().withDeviceId(deviceId).withBody(body).build();
    }

    public UserDevice putMobiledevice(PutMobiledeviceRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserDevice> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserDevice>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserDevice> putMobiledevice(ApiRequest<UserDevice> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserDevice>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

