/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AnalyticsQueryFilter;
import com.mypurecloud.sdk.v2.model.AnalyticsView;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AggregationQuery
implements Serializable {
    private String interval = null;
    private String granularity = null;
    private String timeZone = null;
    private List<GroupByEnum> groupBy = new ArrayList<GroupByEnum>();
    private AnalyticsQueryFilter filter = null;
    private List<MetricsEnum> metrics = new ArrayList<MetricsEnum>();
    private Boolean flattenMultivaluedDimensions = null;
    private List<AnalyticsView> views = new ArrayList<AnalyticsView>();

    public AggregationQuery interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public AggregationQuery granularity(String granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Granularity aggregates metrics into subpartitions within the time interval specified. The default granularity is the same duration as the interval. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H")
    @JsonProperty(value="granularity")
    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public AggregationQuery timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="Sets the time zone for the query interval, defaults to UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public AggregationQuery groupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting aggregate computations into distinct named subgroups rather than across the entire result set as if it were one group.")
    @JsonProperty(value="groupBy")
    public List<GroupByEnum> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
    }

    public AggregationQuery filter(AnalyticsQueryFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL WHERE clause. This is ANDed with the interval parameter. Expresses boolean logical predicates as well as dimensional filters")
    @JsonProperty(value="filter")
    public AnalyticsQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AnalyticsQueryFilter filter) {
        this.filter = filter;
    }

    public AggregationQuery metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).")
    @JsonProperty(value="metrics")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public AggregationQuery flattenMultivaluedDimensions(Boolean flattenMultivaluedDimensions) {
        this.flattenMultivaluedDimensions = flattenMultivaluedDimensions;
        return this;
    }

    @ApiModelProperty(example="null", value="Flattens any multivalued dimensions used in response groups (e.g. ['a','b','c']->'a,b,c')")
    @JsonProperty(value="flattenMultivaluedDimensions")
    public Boolean getFlattenMultivaluedDimensions() {
        return this.flattenMultivaluedDimensions;
    }

    public void setFlattenMultivaluedDimensions(Boolean flattenMultivaluedDimensions) {
        this.flattenMultivaluedDimensions = flattenMultivaluedDimensions;
    }

    public AggregationQuery views(List<AnalyticsView> views) {
        this.views = views;
        return this;
    }

    @ApiModelProperty(example="null", value="Custom derived metric views")
    @JsonProperty(value="views")
    public List<AnalyticsView> getViews() {
        return this.views;
    }

    public void setViews(List<AnalyticsView> views) {
        this.views = views;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationQuery aggregationQuery = (AggregationQuery)o;
        return Objects.equals(this.interval, aggregationQuery.interval) && Objects.equals(this.granularity, aggregationQuery.granularity) && Objects.equals(this.timeZone, aggregationQuery.timeZone) && Objects.equals(this.groupBy, aggregationQuery.groupBy) && Objects.equals(this.filter, aggregationQuery.filter) && Objects.equals(this.metrics, aggregationQuery.metrics) && Objects.equals(this.flattenMultivaluedDimensions, aggregationQuery.flattenMultivaluedDimensions) && Objects.equals(this.views, aggregationQuery.views);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.granularity, this.timeZone, this.groupBy, this.filter, this.metrics, this.flattenMultivaluedDimensions, this.views);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AggregationQuery {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString(this.granularity)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    flattenMultivaluedDimensions: ").append(this.toIndentedString(this.flattenMultivaluedDimensions)).append("\n");
        sb.append("    views: ").append(this.toIndentedString(this.views)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MetricsEnum {
        TSEGMENTDURATION("tSegmentDuration"),
        TCONVERSATIONDURATION("tConversationDuration"),
        OTOTALCRITICALSCORE("oTotalCriticalScore"),
        OTOTALSCORE("oTotalScore"),
        NEVALUATIONS("nEvaluations"),
        TABANDON("tAbandon"),
        TIVR("tIvr"),
        TANSWERED("tAnswered"),
        TACD("tAcd"),
        TTALK("tTalk"),
        THELD("tHeld"),
        TTALKCOMPLETE("tTalkComplete"),
        THELDCOMPLETE("tHeldComplete"),
        TACW("tAcw"),
        THANDLE("tHandle"),
        TWAIT("tWait"),
        TAGENTROUTINGSTATUS("tAgentRoutingStatus"),
        TORGANIZATIONPRESENCE("tOrganizationPresence"),
        TSYSTEMPRESENCE("tSystemPresence"),
        TUSERRESPONSETIME("tUserResponseTime"),
        TAGENTRESPONSETIME("tAgentResponseTime"),
        NOFFERED("nOffered"),
        NOVERSLA("nOverSla"),
        NTRANSFERRED("nTransferred"),
        NOUTBOUNDATTEMPTED("nOutboundAttempted"),
        NOUTBOUNDCONNECTED("nOutboundConnected"),
        NOUTBOUNDABANDONED("nOutboundAbandoned"),
        NERROR("nError"),
        OSERVICETARGET("oServiceTarget"),
        OSERVICELEVEL("oServiceLevel"),
        TACTIVE("tActive"),
        TINACTIVE("tInactive"),
        OACTIVEUSERS("oActiveUsers"),
        OMEMBERUSERS("oMemberUsers"),
        OACTIVEQUEUES("oActiveQueues"),
        OMEMBERQUEUES("oMemberQueues"),
        OINTERACTING("oInteracting"),
        OWAITING("oWaiting"),
        OONQUEUEUSERS("oOnQueueUsers"),
        OOFFQUEUEUSERS("oOffQueueUsers"),
        OUSERPRESENCES("oUserPresences"),
        OUSERROUTINGSTATUSES("oUserRoutingStatuses");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricsEnum value : MetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum GroupByEnum {
        CONVERSATIONID("conversationId"),
        SESSIONID("sessionId"),
        MEDIATYPE("mediaType"),
        QUEUEID("queueId"),
        USERID("userId"),
        PARTICIPANTID("participantId"),
        PARTICIPANTNAME("participantName"),
        DIRECTION("direction"),
        WRAPUPCODE("wrapUpCode"),
        WRAPUPNOTE("wrapUpNote"),
        INTERACTIONTYPE("interactionType"),
        REQUESTEDROUTINGSKILLID("requestedRoutingSkillId"),
        REQUESTEDLANGUAGEID("requestedLanguageId"),
        PURPOSE("purpose"),
        PARTICIPANTTYPE("participantType"),
        SEGMENTTYPE("segmentType"),
        DISCONNECTTYPE("disconnectType"),
        ERRORCODE("errorCode"),
        CONVERSATIONEND("conversationEnd"),
        SEGMENTEND("segmentEnd"),
        EXTERNALCONTACTID("externalContactId"),
        EXTERNALORGANIZATIONID("externalOrganizationId"),
        STATIONID("stationId"),
        EDGEID("edgeId"),
        DNIS("dnis"),
        ANI("ani"),
        OUTBOUNDCAMPAIGNID("outboundCampaignId"),
        OUTBOUNDCONTACTID("outboundContactId"),
        OUTBOUNDCONTACTLISTID("outboundContactListId"),
        MONITOREDPARTICIPANTID("monitoredParticipantId"),
        SOURCESESSIONID("sourceSessionId"),
        DESTINATIONSESSIONID("destinationSessionId"),
        SOURCECONVERSATIONID("sourceConversationId"),
        DESTINATIONCONVERSATIONID("destinationConversationId"),
        REMOTENAMEDISPLAYABLE("remoteNameDisplayable"),
        SIPRESPONSECODE("sipResponseCode"),
        Q850RESPONSECODE("q850ResponseCode"),
        CONFERENCE("conference"),
        GROUPID("groupId"),
        ROOMID("roomId"),
        ADDRESSFROM("addressFrom"),
        ADDRESSTO("addressTo"),
        SUBJECT("subject"),
        PEERID("peerId"),
        SCRIPTID("scriptId"),
        EVALUATIONID("evaluationId"),
        EVALUATORID("evaluatorId"),
        CONTEXTID("contextId"),
        FORMID("formId"),
        FORMNAME("formName"),
        EVENTTIME("eventTime"),
        SYSTEMPRESENCE("systemPresence"),
        ORGANIZATIONPRESENCEID("organizationPresenceId"),
        ROUTINGSTATUS("routingStatus");

        private String value;

        private GroupByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GroupByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GroupByEnum value : GroupByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GroupByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

