/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CreateOutboundMessagingConversationRequest
implements Serializable {
    private String queueId = null;
    private String toAddress = null;
    private ToAddressMessengerTypeEnum toAddressMessengerType = null;
    private Boolean useExistingConversation = null;
    private String externalContactId = null;

    public CreateOutboundMessagingConversationRequest queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the queue to be associated with the message. This will determine the fromAddress of the message.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public CreateOutboundMessagingConversationRequest toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The messaging address of the recipient of the message. For an SMS messenger type, the phone number address must be in E.164 format. E.g. +13175555555 or +34234234234.  For open messenger type, any string within the outbound.open.messaging.to.address.characters.max limit can be used.")
    @JsonProperty(value="toAddress")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public CreateOutboundMessagingConversationRequest toAddressMessengerType(ToAddressMessengerTypeEnum toAddressMessengerType) {
        this.toAddressMessengerType = toAddressMessengerType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The messaging address messenger type.")
    @JsonProperty(value="toAddressMessengerType")
    public ToAddressMessengerTypeEnum getToAddressMessengerType() {
        return this.toAddressMessengerType;
    }

    public void setToAddressMessengerType(ToAddressMessengerTypeEnum toAddressMessengerType) {
        this.toAddressMessengerType = toAddressMessengerType;
    }

    public CreateOutboundMessagingConversationRequest useExistingConversation(Boolean useExistingConversation) {
        this.useExistingConversation = useExistingConversation;
        return this;
    }

    @ApiModelProperty(example="null", value="An override to use an existing conversation.  If set to true, an existing conversation will be used if there is one within the conversation window.  If set to false, create request fails if there is a conversation within the conversation window.")
    @JsonProperty(value="useExistingConversation")
    public Boolean getUseExistingConversation() {
        return this.useExistingConversation;
    }

    public void setUseExistingConversation(Boolean useExistingConversation) {
        this.useExistingConversation = useExistingConversation;
    }

    public CreateOutboundMessagingConversationRequest externalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
        return this;
    }

    @ApiModelProperty(example="null", value="The external contact with which the message will be associated.")
    @JsonProperty(value="externalContactId")
    public String getExternalContactId() {
        return this.externalContactId;
    }

    public void setExternalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOutboundMessagingConversationRequest createOutboundMessagingConversationRequest = (CreateOutboundMessagingConversationRequest)o;
        return Objects.equals(this.queueId, createOutboundMessagingConversationRequest.queueId) && Objects.equals(this.toAddress, createOutboundMessagingConversationRequest.toAddress) && Objects.equals((Object)this.toAddressMessengerType, (Object)createOutboundMessagingConversationRequest.toAddressMessengerType) && Objects.equals(this.useExistingConversation, createOutboundMessagingConversationRequest.useExistingConversation) && Objects.equals(this.externalContactId, createOutboundMessagingConversationRequest.externalContactId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queueId, this.toAddress, this.toAddressMessengerType, this.useExistingConversation, this.externalContactId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOutboundMessagingConversationRequest {\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    toAddressMessengerType: ").append(this.toIndentedString((Object)this.toAddressMessengerType)).append("\n");
        sb.append("    useExistingConversation: ").append(this.toIndentedString(this.useExistingConversation)).append("\n");
        sb.append("    externalContactId: ").append(this.toIndentedString(this.externalContactId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ToAddressMessengerTypeEnumDeserializer.class)
    public static enum ToAddressMessengerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SMS("sms"),
        OPEN("open");

        private String value;

        private ToAddressMessengerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ToAddressMessengerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ToAddressMessengerTypeEnum value : ToAddressMessengerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ToAddressMessengerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ToAddressMessengerTypeEnumDeserializer
    extends StdDeserializer<ToAddressMessengerTypeEnum> {
        public ToAddressMessengerTypeEnumDeserializer() {
            super(ToAddressMessengerTypeEnumDeserializer.class);
        }

        public ToAddressMessengerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ToAddressMessengerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

