/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class SentimentFeedback
implements Serializable {
    private String id = null;
    private String phrase = null;
    private String dialect = null;
    private FeedbackValueEnum feedbackValue = null;
    private Date dateCreated = null;
    private AddressableEntityRef createdBy = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public SentimentFeedback phrase(String phrase) {
        this.phrase = phrase;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The phrase for which sentiment feedback is provided")
    @JsonProperty(value="phrase")
    public String getPhrase() {
        return this.phrase;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public SentimentFeedback dialect(String dialect) {
        this.dialect = dialect;
        return this;
    }

    @ApiModelProperty(example="en-US", required=true, value="The dialect for the given phrase, dialect format is {language}-{country} where language follows ISO 639-1 standard and country follows ISO 3166-1 alpha 2 standard")
    @JsonProperty(value="dialect")
    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public SentimentFeedback feedbackValue(FeedbackValueEnum feedbackValue) {
        this.feedbackValue = feedbackValue;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The sentiment feedback value for the given phrase")
    @JsonProperty(value="feedbackValue")
    public FeedbackValueEnum getFeedbackValue() {
        return this.feedbackValue;
    }

    public void setFeedbackValue(FeedbackValueEnum feedbackValue) {
        this.feedbackValue = feedbackValue;
    }

    @ApiModelProperty(example="null", value="The Timestamp when sentiment feedback created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The Id of user who created the sentiment feedback")
    @JsonProperty(value="createdBy")
    public AddressableEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentimentFeedback sentimentFeedback = (SentimentFeedback)o;
        return Objects.equals(this.id, sentimentFeedback.id) && Objects.equals(this.phrase, sentimentFeedback.phrase) && Objects.equals(this.dialect, sentimentFeedback.dialect) && Objects.equals((Object)this.feedbackValue, (Object)sentimentFeedback.feedbackValue) && Objects.equals(this.dateCreated, sentimentFeedback.dateCreated) && Objects.equals(this.createdBy, sentimentFeedback.createdBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.phrase, this.dialect, this.feedbackValue, this.dateCreated, this.createdBy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SentimentFeedback {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    phrase: ").append(this.toIndentedString(this.phrase)).append("\n");
        sb.append("    dialect: ").append(this.toIndentedString(this.dialect)).append("\n");
        sb.append("    feedbackValue: ").append(this.toIndentedString((Object)this.feedbackValue)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FeedbackValueEnumDeserializer.class)
    public static enum FeedbackValueEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NEUTRAL("Neutral"),
        POSITIVE("Positive"),
        NEGATIVE("Negative");

        private String value;

        private FeedbackValueEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeedbackValueEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FeedbackValueEnum value : FeedbackValueEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FeedbackValueEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FeedbackValueEnumDeserializer
    extends StdDeserializer<FeedbackValueEnum> {
        public FeedbackValueEnumDeserializer() {
            super(FeedbackValueEnumDeserializer.class);
        }

        public FeedbackValueEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FeedbackValueEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

