/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.TextBotFlowLocation;
import com.mypurecloud.sdk.v2.model.TextBotFlowOutcome;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Settings for a next-action of disconnecting, including the reason code for the disconnect.")
public class TextBotDisconnectAction
implements Serializable {
    private ReasonEnum reason = null;
    private String reasonExtendedInfo = null;
    private TextBotFlowLocation flowLocation = null;
    private List<TextBotFlowOutcome> flowOutcomes = null;

    public TextBotDisconnectAction reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The reason for the disconnect.")
    @JsonProperty(value="reason")
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public TextBotDisconnectAction reasonExtendedInfo(String reasonExtendedInfo) {
        this.reasonExtendedInfo = reasonExtendedInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Extended information related to the reason, if available.")
    @JsonProperty(value="reasonExtendedInfo")
    public String getReasonExtendedInfo() {
        return this.reasonExtendedInfo;
    }

    public void setReasonExtendedInfo(String reasonExtendedInfo) {
        this.reasonExtendedInfo = reasonExtendedInfo;
    }

    public TextBotDisconnectAction flowLocation(TextBotFlowLocation flowLocation) {
        this.flowLocation = flowLocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Describes where in the Bot Flow the user was when the disconnect occurred.")
    @JsonProperty(value="flowLocation")
    public TextBotFlowLocation getFlowLocation() {
        return this.flowLocation;
    }

    public void setFlowLocation(TextBotFlowLocation flowLocation) {
        this.flowLocation = flowLocation;
    }

    public TextBotDisconnectAction flowOutcomes(List<TextBotFlowOutcome> flowOutcomes) {
        this.flowOutcomes = flowOutcomes;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of Flow Outcomes for the bot flow and their details.")
    @JsonProperty(value="flowOutcomes")
    public List<TextBotFlowOutcome> getFlowOutcomes() {
        return this.flowOutcomes;
    }

    public void setFlowOutcomes(List<TextBotFlowOutcome> flowOutcomes) {
        this.flowOutcomes = flowOutcomes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBotDisconnectAction textBotDisconnectAction = (TextBotDisconnectAction)o;
        return Objects.equals((Object)this.reason, (Object)textBotDisconnectAction.reason) && Objects.equals(this.reasonExtendedInfo, textBotDisconnectAction.reasonExtendedInfo) && Objects.equals(this.flowLocation, textBotDisconnectAction.flowLocation) && Objects.equals(this.flowOutcomes, textBotDisconnectAction.flowOutcomes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.reasonExtendedInfo, this.flowLocation, this.flowOutcomes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextBotDisconnectAction {\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    reasonExtendedInfo: ").append(this.toIndentedString(this.reasonExtendedInfo)).append("\n");
        sb.append("    flowLocation: ").append(this.toIndentedString(this.flowLocation)).append("\n");
        sb.append("    flowOutcomes: ").append(this.toIndentedString(this.flowOutcomes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ReasonEnumDeserializer.class)
    public static enum ReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TRIGGEREDBYUSER("TriggeredByUser"),
        TRIGGEREDBYFLOW("TriggeredByFlow"),
        SESSIONEXPIRED("SessionExpired"),
        ERROR("Error"),
        RECOGNITIONFAILURE("RecognitionFailure");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ReasonEnum value : ReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ReasonEnumDeserializer
    extends StdDeserializer<ReasonEnum> {
        public ReasonEnumDeserializer() {
            super(ReasonEnumDeserializer.class);
        }

        public ReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

