/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.TestExecutionOperationResult;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class TestExecutionResult
implements Serializable {
    private List<TestExecutionOperationResult> operations = null;
    private ErrorBody error = null;
    private Object finalResult = null;
    private Boolean success = null;

    public TestExecutionResult operations(List<TestExecutionOperationResult> operations) {
        this.operations = operations;
        return this;
    }

    @ApiModelProperty(example="null", value="Execution operations performed as part of the test")
    @JsonProperty(value="operations")
    public List<TestExecutionOperationResult> getOperations() {
        return this.operations;
    }

    public void setOperations(List<TestExecutionOperationResult> operations) {
        this.operations = operations;
    }

    public TestExecutionResult error(ErrorBody error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(example="null", value="The final error encountered during the test that resulted in test failure")
    @JsonProperty(value="error")
    public ErrorBody getError() {
        return this.error;
    }

    public void setError(ErrorBody error) {
        this.error = error;
    }

    public TestExecutionResult finalResult(Object finalResult) {
        this.finalResult = finalResult;
        return this;
    }

    @ApiModelProperty(example="null", value="The final result of the test. This is the response that would be returned during normal action execution")
    @JsonProperty(value="finalResult")
    public Object getFinalResult() {
        return this.finalResult;
    }

    public void setFinalResult(Object finalResult) {
        this.finalResult = finalResult;
    }

    public TestExecutionResult success(Boolean success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether or not the test was a success")
    @JsonProperty(value="success")
    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestExecutionResult testExecutionResult = (TestExecutionResult)o;
        return Objects.equals(this.operations, testExecutionResult.operations) && Objects.equals(this.error, testExecutionResult.error) && Objects.equals(this.finalResult, testExecutionResult.finalResult) && Objects.equals(this.success, testExecutionResult.success);
    }

    public int hashCode() {
        return Objects.hash(this.operations, this.error, this.finalResult, this.success);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestExecutionResult {\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    finalResult: ").append(this.toIndentedString(this.finalResult)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

