/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AnswerOption;
import com.mypurecloud.sdk.v2.model.VisibilityCondition;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class SurveyQuestion
implements Serializable {
    private String id = null;
    private String text = null;
    private String helpText = null;
    private TypeEnum type = null;
    private Boolean naEnabled = null;
    private VisibilityCondition visibilityCondition = null;
    private List<AnswerOption> answerOptions = null;
    private Integer maxResponseCharacters = null;
    private String explanationPrompt = null;

    public SurveyQuestion id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SurveyQuestion text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public SurveyQuestion helpText(String helpText) {
        this.helpText = helpText;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="helpText")
    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public SurveyQuestion type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SurveyQuestion naEnabled(Boolean naEnabled) {
        this.naEnabled = naEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="naEnabled")
    public Boolean getNaEnabled() {
        return this.naEnabled;
    }

    public void setNaEnabled(Boolean naEnabled) {
        this.naEnabled = naEnabled;
    }

    public SurveyQuestion visibilityCondition(VisibilityCondition visibilityCondition) {
        this.visibilityCondition = visibilityCondition;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="visibilityCondition")
    public VisibilityCondition getVisibilityCondition() {
        return this.visibilityCondition;
    }

    public void setVisibilityCondition(VisibilityCondition visibilityCondition) {
        this.visibilityCondition = visibilityCondition;
    }

    public SurveyQuestion answerOptions(List<AnswerOption> answerOptions) {
        this.answerOptions = answerOptions;
        return this;
    }

    @ApiModelProperty(example="null", value="Options from which to choose an answer for this question. Only used by Multiple Choice type questions.")
    @JsonProperty(value="answerOptions")
    public List<AnswerOption> getAnswerOptions() {
        return this.answerOptions;
    }

    public void setAnswerOptions(List<AnswerOption> answerOptions) {
        this.answerOptions = answerOptions;
    }

    public SurveyQuestion maxResponseCharacters(Integer maxResponseCharacters) {
        this.maxResponseCharacters = maxResponseCharacters;
        return this;
    }

    @ApiModelProperty(example="null", value="How many characters are allowed in the text response to this question. Used by NPS and Free Text question types.")
    @JsonProperty(value="maxResponseCharacters")
    public Integer getMaxResponseCharacters() {
        return this.maxResponseCharacters;
    }

    public void setMaxResponseCharacters(Integer maxResponseCharacters) {
        this.maxResponseCharacters = maxResponseCharacters;
    }

    public SurveyQuestion explanationPrompt(String explanationPrompt) {
        this.explanationPrompt = explanationPrompt;
        return this;
    }

    @ApiModelProperty(example="null", value="Prompt for details explaining the chosen NPS score. Used by NPS questions.")
    @JsonProperty(value="explanationPrompt")
    public String getExplanationPrompt() {
        return this.explanationPrompt;
    }

    public void setExplanationPrompt(String explanationPrompt) {
        this.explanationPrompt = explanationPrompt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SurveyQuestion surveyQuestion = (SurveyQuestion)o;
        return Objects.equals(this.id, surveyQuestion.id) && Objects.equals(this.text, surveyQuestion.text) && Objects.equals(this.helpText, surveyQuestion.helpText) && Objects.equals((Object)this.type, (Object)surveyQuestion.type) && Objects.equals(this.naEnabled, surveyQuestion.naEnabled) && Objects.equals(this.visibilityCondition, surveyQuestion.visibilityCondition) && Objects.equals(this.answerOptions, surveyQuestion.answerOptions) && Objects.equals(this.maxResponseCharacters, surveyQuestion.maxResponseCharacters) && Objects.equals(this.explanationPrompt, surveyQuestion.explanationPrompt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.text, this.helpText, this.type, this.naEnabled, this.visibilityCondition, this.answerOptions, this.maxResponseCharacters, this.explanationPrompt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SurveyQuestion {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    helpText: ").append(this.toIndentedString(this.helpText)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    naEnabled: ").append(this.toIndentedString(this.naEnabled)).append("\n");
        sb.append("    visibilityCondition: ").append(this.toIndentedString(this.visibilityCondition)).append("\n");
        sb.append("    answerOptions: ").append(this.toIndentedString(this.answerOptions)).append("\n");
        sb.append("    maxResponseCharacters: ").append(this.toIndentedString(this.maxResponseCharacters)).append("\n");
        sb.append("    explanationPrompt: ").append(this.toIndentedString(this.explanationPrompt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MULTIPLECHOICEQUESTION("multipleChoiceQuestion"),
        FREETEXTQUESTION("freeTextQuestion"),
        NPSQUESTION("npsQuestion"),
        READONLYTEXTBLOCKQUESTION("readOnlyTextBlockQuestion");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

