/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.SupportCenterCustomMessage;
import com.mypurecloud.sdk.v2.model.SupportCenterFeedbackSettings;
import com.mypurecloud.sdk.v2.model.SupportCenterScreen;
import com.mypurecloud.sdk.v2.model.SupportCenterStyleSetting;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Settings concerning support center")
public class SupportCenterSettings
implements Serializable {
    private Boolean enabled = null;
    private AddressableEntityRef knowledgeBase = null;
    private List<SupportCenterCustomMessage> customMessages = null;
    private RouterTypeEnum routerType = null;
    private List<SupportCenterScreen> screens = null;
    private List<AddressableEntityRef> enabledCategories = null;
    private SupportCenterStyleSetting styleSetting = null;
    private SupportCenterFeedbackSettings feedback = null;

    public SupportCenterSettings enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not support center is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SupportCenterSettings knowledgeBase(AddressableEntityRef knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
        return this;
    }

    @ApiModelProperty(example="null", value="The knowledge base for support center")
    @JsonProperty(value="knowledgeBase")
    public AddressableEntityRef getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void setKnowledgeBase(AddressableEntityRef knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    public SupportCenterSettings customMessages(List<SupportCenterCustomMessage> customMessages) {
        this.customMessages = customMessages;
        return this;
    }

    @ApiModelProperty(example="null", value="Customizable display texts for support center")
    @JsonProperty(value="customMessages")
    public List<SupportCenterCustomMessage> getCustomMessages() {
        return this.customMessages;
    }

    public void setCustomMessages(List<SupportCenterCustomMessage> customMessages) {
        this.customMessages = customMessages;
    }

    public SupportCenterSettings routerType(RouterTypeEnum routerType) {
        this.routerType = routerType;
        return this;
    }

    @ApiModelProperty(example="null", value="Router type for support center")
    @JsonProperty(value="routerType")
    public RouterTypeEnum getRouterType() {
        return this.routerType;
    }

    public void setRouterType(RouterTypeEnum routerType) {
        this.routerType = routerType;
    }

    public SupportCenterSettings screens(List<SupportCenterScreen> screens) {
        this.screens = screens;
        return this;
    }

    @ApiModelProperty(example="null", value="Available screens for the support center with its modules")
    @JsonProperty(value="screens")
    public List<SupportCenterScreen> getScreens() {
        return this.screens;
    }

    public void setScreens(List<SupportCenterScreen> screens) {
        this.screens = screens;
    }

    public SupportCenterSettings enabledCategories(List<AddressableEntityRef> enabledCategories) {
        this.enabledCategories = enabledCategories;
        return this;
    }

    @ApiModelProperty(example="null", value="Enabled article categories for support center")
    @JsonProperty(value="enabledCategories")
    public List<AddressableEntityRef> getEnabledCategories() {
        return this.enabledCategories;
    }

    public void setEnabledCategories(List<AddressableEntityRef> enabledCategories) {
        this.enabledCategories = enabledCategories;
    }

    public SupportCenterSettings styleSetting(SupportCenterStyleSetting styleSetting) {
        this.styleSetting = styleSetting;
        return this;
    }

    @ApiModelProperty(example="null", value="Style attributes for support center")
    @JsonProperty(value="styleSetting")
    public SupportCenterStyleSetting getStyleSetting() {
        return this.styleSetting;
    }

    public void setStyleSetting(SupportCenterStyleSetting styleSetting) {
        this.styleSetting = styleSetting;
    }

    public SupportCenterSettings feedback(SupportCenterFeedbackSettings feedback) {
        this.feedback = feedback;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer feedback settings")
    @JsonProperty(value="feedback")
    public SupportCenterFeedbackSettings getFeedback() {
        return this.feedback;
    }

    public void setFeedback(SupportCenterFeedbackSettings feedback) {
        this.feedback = feedback;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportCenterSettings supportCenterSettings = (SupportCenterSettings)o;
        return Objects.equals(this.enabled, supportCenterSettings.enabled) && Objects.equals(this.knowledgeBase, supportCenterSettings.knowledgeBase) && Objects.equals(this.customMessages, supportCenterSettings.customMessages) && Objects.equals((Object)this.routerType, (Object)supportCenterSettings.routerType) && Objects.equals(this.screens, supportCenterSettings.screens) && Objects.equals(this.enabledCategories, supportCenterSettings.enabledCategories) && Objects.equals(this.styleSetting, supportCenterSettings.styleSetting) && Objects.equals(this.feedback, supportCenterSettings.feedback);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.knowledgeBase, this.customMessages, this.routerType, this.screens, this.enabledCategories, this.styleSetting, this.feedback});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportCenterSettings {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    knowledgeBase: ").append(this.toIndentedString(this.knowledgeBase)).append("\n");
        sb.append("    customMessages: ").append(this.toIndentedString(this.customMessages)).append("\n");
        sb.append("    routerType: ").append(this.toIndentedString((Object)this.routerType)).append("\n");
        sb.append("    screens: ").append(this.toIndentedString(this.screens)).append("\n");
        sb.append("    enabledCategories: ").append(this.toIndentedString(this.enabledCategories)).append("\n");
        sb.append("    styleSetting: ").append(this.toIndentedString(this.styleSetting)).append("\n");
        sb.append("    feedback: ").append(this.toIndentedString(this.feedback)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RouterTypeEnumDeserializer.class)
    public static enum RouterTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HASH("Hash"),
        BROWSER("Browser");

        private String value;

        private RouterTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RouterTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RouterTypeEnum value : RouterTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RouterTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RouterTypeEnumDeserializer
    extends StdDeserializer<RouterTypeEnum> {
        public RouterTypeEnumDeserializer() {
            super(RouterTypeEnumDeserializer.class);
        }

        public RouterTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RouterTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

