/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ShiftTradeActivityRule;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class ShiftTradeSettings
implements Serializable {
    private Boolean enabled = null;
    private Boolean autoReview = null;
    private Boolean allowDirectTrades = null;
    private Integer minHoursInFuture = null;
    private UnequalPaidEnum unequalPaid = null;
    private OneSidedEnum oneSided = null;
    private WeeklyMinPaidViolationsEnum weeklyMinPaidViolations = null;
    private WeeklyMaxPaidViolationsEnum weeklyMaxPaidViolations = null;
    private Boolean requiresMatchingQueues = null;
    private Boolean requiresMatchingLanguages = null;
    private Boolean requiresMatchingSkills = null;
    private Boolean requiresMatchingPlanningGroups = null;
    private List<ShiftTradeActivityRule> activityCategoryRules = null;

    public ShiftTradeSettings enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether shift trading is enabled for this management unit")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ShiftTradeSettings autoReview(Boolean autoReview) {
        this.autoReview = autoReview;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether automatic shift trade review is enabled according to the rules defined in for this management unit")
    @JsonProperty(value="autoReview")
    public Boolean getAutoReview() {
        return this.autoReview;
    }

    public void setAutoReview(Boolean autoReview) {
        this.autoReview = autoReview;
    }

    public ShiftTradeSettings allowDirectTrades(Boolean allowDirectTrades) {
        this.allowDirectTrades = allowDirectTrades;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether direct shift trades between agents are allowed")
    @JsonProperty(value="allowDirectTrades")
    public Boolean getAllowDirectTrades() {
        return this.allowDirectTrades;
    }

    public void setAllowDirectTrades(Boolean allowDirectTrades) {
        this.allowDirectTrades = allowDirectTrades;
    }

    public ShiftTradeSettings minHoursInFuture(Integer minHoursInFuture) {
        this.minHoursInFuture = minHoursInFuture;
        return this;
    }

    @ApiModelProperty(example="null", value="The minimum number of hours in the future shift trades are allowed")
    @JsonProperty(value="minHoursInFuture")
    public Integer getMinHoursInFuture() {
        return this.minHoursInFuture;
    }

    public void setMinHoursInFuture(Integer minHoursInFuture) {
        this.minHoursInFuture = minHoursInFuture;
    }

    public ShiftTradeSettings unequalPaid(UnequalPaidEnum unequalPaid) {
        this.unequalPaid = unequalPaid;
        return this;
    }

    @ApiModelProperty(example="null", value="How to handle shift trades which involve unequal paid times")
    @JsonProperty(value="unequalPaid")
    public UnequalPaidEnum getUnequalPaid() {
        return this.unequalPaid;
    }

    public void setUnequalPaid(UnequalPaidEnum unequalPaid) {
        this.unequalPaid = unequalPaid;
    }

    public ShiftTradeSettings oneSided(OneSidedEnum oneSided) {
        this.oneSided = oneSided;
        return this;
    }

    @ApiModelProperty(example="null", value="How to handle one-sided shift trades")
    @JsonProperty(value="oneSided")
    public OneSidedEnum getOneSided() {
        return this.oneSided;
    }

    public void setOneSided(OneSidedEnum oneSided) {
        this.oneSided = oneSided;
    }

    public ShiftTradeSettings weeklyMinPaidViolations(WeeklyMinPaidViolationsEnum weeklyMinPaidViolations) {
        this.weeklyMinPaidViolations = weeklyMinPaidViolations;
        return this;
    }

    @ApiModelProperty(example="null", value="How to handle shift trades which result in violations of weekly minimum paid time constraint")
    @JsonProperty(value="weeklyMinPaidViolations")
    public WeeklyMinPaidViolationsEnum getWeeklyMinPaidViolations() {
        return this.weeklyMinPaidViolations;
    }

    public void setWeeklyMinPaidViolations(WeeklyMinPaidViolationsEnum weeklyMinPaidViolations) {
        this.weeklyMinPaidViolations = weeklyMinPaidViolations;
    }

    public ShiftTradeSettings weeklyMaxPaidViolations(WeeklyMaxPaidViolationsEnum weeklyMaxPaidViolations) {
        this.weeklyMaxPaidViolations = weeklyMaxPaidViolations;
        return this;
    }

    @ApiModelProperty(example="null", value="How to handle shift trades which result in violations of weekly maximum paid time constraint")
    @JsonProperty(value="weeklyMaxPaidViolations")
    public WeeklyMaxPaidViolationsEnum getWeeklyMaxPaidViolations() {
        return this.weeklyMaxPaidViolations;
    }

    public void setWeeklyMaxPaidViolations(WeeklyMaxPaidViolationsEnum weeklyMaxPaidViolations) {
        this.weeklyMaxPaidViolations = weeklyMaxPaidViolations;
    }

    public ShiftTradeSettings requiresMatchingQueues(Boolean requiresMatchingQueues) {
        this.requiresMatchingQueues = requiresMatchingQueues;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to constrain shift trades to agents with matching queues")
    @JsonProperty(value="requiresMatchingQueues")
    public Boolean getRequiresMatchingQueues() {
        return this.requiresMatchingQueues;
    }

    public void setRequiresMatchingQueues(Boolean requiresMatchingQueues) {
        this.requiresMatchingQueues = requiresMatchingQueues;
    }

    public ShiftTradeSettings requiresMatchingLanguages(Boolean requiresMatchingLanguages) {
        this.requiresMatchingLanguages = requiresMatchingLanguages;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to constrain shift trades to agents with matching languages")
    @JsonProperty(value="requiresMatchingLanguages")
    public Boolean getRequiresMatchingLanguages() {
        return this.requiresMatchingLanguages;
    }

    public void setRequiresMatchingLanguages(Boolean requiresMatchingLanguages) {
        this.requiresMatchingLanguages = requiresMatchingLanguages;
    }

    public ShiftTradeSettings requiresMatchingSkills(Boolean requiresMatchingSkills) {
        this.requiresMatchingSkills = requiresMatchingSkills;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to constrain shift trades to agents with matching skills")
    @JsonProperty(value="requiresMatchingSkills")
    public Boolean getRequiresMatchingSkills() {
        return this.requiresMatchingSkills;
    }

    public void setRequiresMatchingSkills(Boolean requiresMatchingSkills) {
        this.requiresMatchingSkills = requiresMatchingSkills;
    }

    public ShiftTradeSettings requiresMatchingPlanningGroups(Boolean requiresMatchingPlanningGroups) {
        this.requiresMatchingPlanningGroups = requiresMatchingPlanningGroups;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to constrain shift trades to agents with matching planning groups")
    @JsonProperty(value="requiresMatchingPlanningGroups")
    public Boolean getRequiresMatchingPlanningGroups() {
        return this.requiresMatchingPlanningGroups;
    }

    public void setRequiresMatchingPlanningGroups(Boolean requiresMatchingPlanningGroups) {
        this.requiresMatchingPlanningGroups = requiresMatchingPlanningGroups;
    }

    public ShiftTradeSettings activityCategoryRules(List<ShiftTradeActivityRule> activityCategoryRules) {
        this.activityCategoryRules = activityCategoryRules;
        return this;
    }

    @ApiModelProperty(example="null", value="Rules that specify what to do with activity categories that are part of a shift defined in a trade")
    @JsonProperty(value="activityCategoryRules")
    public List<ShiftTradeActivityRule> getActivityCategoryRules() {
        return this.activityCategoryRules;
    }

    public void setActivityCategoryRules(List<ShiftTradeActivityRule> activityCategoryRules) {
        this.activityCategoryRules = activityCategoryRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftTradeSettings shiftTradeSettings = (ShiftTradeSettings)o;
        return Objects.equals(this.enabled, shiftTradeSettings.enabled) && Objects.equals(this.autoReview, shiftTradeSettings.autoReview) && Objects.equals(this.allowDirectTrades, shiftTradeSettings.allowDirectTrades) && Objects.equals(this.minHoursInFuture, shiftTradeSettings.minHoursInFuture) && Objects.equals((Object)this.unequalPaid, (Object)shiftTradeSettings.unequalPaid) && Objects.equals((Object)this.oneSided, (Object)shiftTradeSettings.oneSided) && Objects.equals((Object)this.weeklyMinPaidViolations, (Object)shiftTradeSettings.weeklyMinPaidViolations) && Objects.equals((Object)this.weeklyMaxPaidViolations, (Object)shiftTradeSettings.weeklyMaxPaidViolations) && Objects.equals(this.requiresMatchingQueues, shiftTradeSettings.requiresMatchingQueues) && Objects.equals(this.requiresMatchingLanguages, shiftTradeSettings.requiresMatchingLanguages) && Objects.equals(this.requiresMatchingSkills, shiftTradeSettings.requiresMatchingSkills) && Objects.equals(this.requiresMatchingPlanningGroups, shiftTradeSettings.requiresMatchingPlanningGroups) && Objects.equals(this.activityCategoryRules, shiftTradeSettings.activityCategoryRules);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.autoReview, this.allowDirectTrades, this.minHoursInFuture, this.unequalPaid, this.oneSided, this.weeklyMinPaidViolations, this.weeklyMaxPaidViolations, this.requiresMatchingQueues, this.requiresMatchingLanguages, this.requiresMatchingSkills, this.requiresMatchingPlanningGroups, this.activityCategoryRules});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftTradeSettings {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    autoReview: ").append(this.toIndentedString(this.autoReview)).append("\n");
        sb.append("    allowDirectTrades: ").append(this.toIndentedString(this.allowDirectTrades)).append("\n");
        sb.append("    minHoursInFuture: ").append(this.toIndentedString(this.minHoursInFuture)).append("\n");
        sb.append("    unequalPaid: ").append(this.toIndentedString((Object)this.unequalPaid)).append("\n");
        sb.append("    oneSided: ").append(this.toIndentedString((Object)this.oneSided)).append("\n");
        sb.append("    weeklyMinPaidViolations: ").append(this.toIndentedString((Object)this.weeklyMinPaidViolations)).append("\n");
        sb.append("    weeklyMaxPaidViolations: ").append(this.toIndentedString((Object)this.weeklyMaxPaidViolations)).append("\n");
        sb.append("    requiresMatchingQueues: ").append(this.toIndentedString(this.requiresMatchingQueues)).append("\n");
        sb.append("    requiresMatchingLanguages: ").append(this.toIndentedString(this.requiresMatchingLanguages)).append("\n");
        sb.append("    requiresMatchingSkills: ").append(this.toIndentedString(this.requiresMatchingSkills)).append("\n");
        sb.append("    requiresMatchingPlanningGroups: ").append(this.toIndentedString(this.requiresMatchingPlanningGroups)).append("\n");
        sb.append("    activityCategoryRules: ").append(this.toIndentedString(this.activityCategoryRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=WeeklyMaxPaidViolationsEnumDeserializer.class)
    public static enum WeeklyMaxPaidViolationsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALLOW("Allow"),
        DISALLOW("Disallow"),
        ADMINREVIEW("AdminReview");

        private String value;

        private WeeklyMaxPaidViolationsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static WeeklyMaxPaidViolationsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (WeeklyMaxPaidViolationsEnum value : WeeklyMaxPaidViolationsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return WeeklyMaxPaidViolationsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class WeeklyMaxPaidViolationsEnumDeserializer
    extends StdDeserializer<WeeklyMaxPaidViolationsEnum> {
        public WeeklyMaxPaidViolationsEnumDeserializer() {
            super(WeeklyMaxPaidViolationsEnumDeserializer.class);
        }

        public WeeklyMaxPaidViolationsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return WeeklyMaxPaidViolationsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=WeeklyMinPaidViolationsEnumDeserializer.class)
    public static enum WeeklyMinPaidViolationsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALLOW("Allow"),
        DISALLOW("Disallow"),
        ADMINREVIEW("AdminReview");

        private String value;

        private WeeklyMinPaidViolationsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static WeeklyMinPaidViolationsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (WeeklyMinPaidViolationsEnum value : WeeklyMinPaidViolationsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return WeeklyMinPaidViolationsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class WeeklyMinPaidViolationsEnumDeserializer
    extends StdDeserializer<WeeklyMinPaidViolationsEnum> {
        public WeeklyMinPaidViolationsEnumDeserializer() {
            super(WeeklyMinPaidViolationsEnumDeserializer.class);
        }

        public WeeklyMinPaidViolationsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return WeeklyMinPaidViolationsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=OneSidedEnumDeserializer.class)
    public static enum OneSidedEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALLOW("Allow"),
        DISALLOW("Disallow"),
        ADMINREVIEW("AdminReview");

        private String value;

        private OneSidedEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OneSidedEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OneSidedEnum value : OneSidedEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OneSidedEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OneSidedEnumDeserializer
    extends StdDeserializer<OneSidedEnum> {
        public OneSidedEnumDeserializer() {
            super(OneSidedEnumDeserializer.class);
        }

        public OneSidedEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OneSidedEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=UnequalPaidEnumDeserializer.class)
    public static enum UnequalPaidEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALLOW("Allow"),
        DISALLOW("Disallow"),
        ADMINREVIEW("AdminReview");

        private String value;

        private UnequalPaidEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnequalPaidEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnequalPaidEnum value : UnequalPaidEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnequalPaidEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UnequalPaidEnumDeserializer
    extends StdDeserializer<UnequalPaidEnum> {
        public UnequalPaidEnumDeserializer() {
            super(UnequalPaidEnumDeserializer.class);
        }

        public UnequalPaidEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnequalPaidEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

