/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ScimMetadata;
import com.mypurecloud.sdk.v2.model.ScimV2SchemaAttribute;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines a SCIM schema.")
public class ScimV2SchemaDefinition
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private List<ScimV2SchemaAttribute> attributes = null;
    private ScimMetadata meta = null;

    @ApiModelProperty(example="null", value="The ID of the SCIM resource. Set by the service provider. \"caseExact\" is set to \"true\". \"mutability\" is set to \"readOnly\". \"returned\" is set to \"always\".")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The name of the schema.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="The description of the schema.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="The list of service provider attributes.")
    @JsonProperty(value="attributes")
    public List<ScimV2SchemaAttribute> getAttributes() {
        return this.attributes;
    }

    @ApiModelProperty(example="null", value="The metadata of the SCIM resource. Only \"location\" and \"resourceType\" are set for \"Schema\" resources.")
    @JsonProperty(value="meta")
    public ScimMetadata getMeta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimV2SchemaDefinition scimV2SchemaDefinition = (ScimV2SchemaDefinition)o;
        return Objects.equals(this.id, scimV2SchemaDefinition.id) && Objects.equals(this.name, scimV2SchemaDefinition.name) && Objects.equals(this.description, scimV2SchemaDefinition.description) && Objects.equals(this.attributes, scimV2SchemaDefinition.attributes) && Objects.equals(this.meta, scimV2SchemaDefinition.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.attributes, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimV2SchemaDefinition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

