/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Actions;
import com.mypurecloud.sdk.v2.model.ExpansionCriterium;
import com.mypurecloud.sdk.v2.model.MemberGroup;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class Ring
implements Serializable {
    private List<ExpansionCriterium> expansionCriteria = null;
    private Actions actions = null;
    private List<MemberGroup> memberGroups = null;

    public Ring expansionCriteria(List<ExpansionCriterium> expansionCriteria) {
        this.expansionCriteria = expansionCriteria;
        return this;
    }

    @ApiModelProperty(example="null", value="The conditions that will trigger conversations to move to the next bullseye ring.")
    @JsonProperty(value="expansionCriteria")
    public List<ExpansionCriterium> getExpansionCriteria() {
        return this.expansionCriteria;
    }

    public void setExpansionCriteria(List<ExpansionCriterium> expansionCriteria) {
        this.expansionCriteria = expansionCriteria;
    }

    public Ring actions(Actions actions) {
        this.actions = actions;
        return this;
    }

    @ApiModelProperty(example="null", value="The actions that will be performed just before moving conversations to the next bullseye ring.")
    @JsonProperty(value="actions")
    public Actions getActions() {
        return this.actions;
    }

    public void setActions(Actions actions) {
        this.actions = actions;
    }

    public Ring memberGroups(List<MemberGroup> memberGroups) {
        this.memberGroups = memberGroups;
        return this;
    }

    @ApiModelProperty(example="null", value="The groups of agents associated with the ring, if any.  Ring membership will update to match group membership changes.")
    @JsonProperty(value="memberGroups")
    public List<MemberGroup> getMemberGroups() {
        return this.memberGroups;
    }

    public void setMemberGroups(List<MemberGroup> memberGroups) {
        this.memberGroups = memberGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ring ring = (Ring)o;
        return Objects.equals(this.expansionCriteria, ring.expansionCriteria) && Objects.equals(this.actions, ring.actions) && Objects.equals(this.memberGroups, ring.memberGroups);
    }

    public int hashCode() {
        return Objects.hash(this.expansionCriteria, this.actions, this.memberGroups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Ring {\n");
        sb.append("    expansionCriteria: ").append(this.toIndentedString(this.expansionCriteria)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    memberGroups: ").append(this.toIndentedString(this.memberGroups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

