/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.OpenMessageContent;
import com.mypurecloud.sdk.v2.model.OpenMessageEvent;
import com.mypurecloud.sdk.v2.model.OpenMessagingChannel;
import com.mypurecloud.sdk.v2.model.Reason;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Open Messaging rich media message structure")
public class OpenNormalizedMessage
implements Serializable {
    private String id = null;
    private OpenMessagingChannel channel = null;
    private TypeEnum type = null;
    private String text = null;
    private List<OpenMessageContent> content = null;
    private List<OpenMessageEvent> events = null;
    private StatusEnum status = null;
    private List<Reason> reasons = null;
    private Boolean isFinalReceipt = null;
    private DirectionEnum direction = null;
    private Map<String, String> metadata = null;

    public OpenNormalizedMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique ID of the message. This ID is generated by Messaging Platform. Message receipts will have the same ID as the message they reference, as such should only be set when sending a message receipt.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OpenNormalizedMessage channel(OpenMessagingChannel channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Channel-specific information that describes the message and the message channel/provider.")
    @JsonProperty(value="channel")
    public OpenMessagingChannel getChannel() {
        return this.channel;
    }

    public void setChannel(OpenMessagingChannel channel) {
        this.channel = channel;
    }

    public OpenNormalizedMessage type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message type.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OpenNormalizedMessage text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Message text.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public OpenNormalizedMessage content(List<OpenMessageContent> content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="null", value="List of content elements.")
    @JsonProperty(value="content")
    public List<OpenMessageContent> getContent() {
        return this.content;
    }

    public void setContent(List<OpenMessageContent> content) {
        this.content = content;
    }

    public OpenNormalizedMessage events(List<OpenMessageEvent> events) {
        this.events = events;
        return this;
    }

    @ApiModelProperty(example="null", value="List of event elements.")
    @JsonProperty(value="events")
    public List<OpenMessageEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<OpenMessageEvent> events) {
        this.events = events;
    }

    public OpenNormalizedMessage status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Message receipt status, only used with type Receipt.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OpenNormalizedMessage reasons(List<Reason> reasons) {
        this.reasons = reasons;
        return this;
    }

    @ApiModelProperty(example="null", value="List of reasons for a message receipt that indicates the message has failed. Only used with Failed status.")
    @JsonProperty(value="reasons")
    public List<Reason> getReasons() {
        return this.reasons;
    }

    public void setReasons(List<Reason> reasons) {
        this.reasons = reasons;
    }

    public OpenNormalizedMessage isFinalReceipt(Boolean isFinalReceipt) {
        this.isFinalReceipt = isFinalReceipt;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if this is the last message receipt for this message, or if another message receipt can be expected.")
    @JsonProperty(value="isFinalReceipt")
    public Boolean getIsFinalReceipt() {
        return this.isFinalReceipt;
    }

    public void setIsFinalReceipt(Boolean isFinalReceipt) {
        this.isFinalReceipt = isFinalReceipt;
    }

    public OpenNormalizedMessage direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the message.")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public OpenNormalizedMessage metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional metadata about this message.")
    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenNormalizedMessage openNormalizedMessage = (OpenNormalizedMessage)o;
        return Objects.equals(this.id, openNormalizedMessage.id) && Objects.equals(this.channel, openNormalizedMessage.channel) && Objects.equals((Object)this.type, (Object)openNormalizedMessage.type) && Objects.equals(this.text, openNormalizedMessage.text) && Objects.equals(this.content, openNormalizedMessage.content) && Objects.equals(this.events, openNormalizedMessage.events) && Objects.equals((Object)this.status, (Object)openNormalizedMessage.status) && Objects.equals(this.reasons, openNormalizedMessage.reasons) && Objects.equals(this.isFinalReceipt, openNormalizedMessage.isFinalReceipt) && Objects.equals((Object)this.direction, (Object)openNormalizedMessage.direction) && Objects.equals(this.metadata, openNormalizedMessage.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.channel, this.type, this.text, this.content, this.events, this.status, this.reasons, this.isFinalReceipt, this.direction, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenNormalizedMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reasons: ").append(this.toIndentedString(this.reasons)).append("\n");
        sb.append("    isFinalReceipt: ").append(this.toIndentedString(this.isFinalReceipt)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("Inbound"),
        OUTBOUND("Outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SENT("Sent"),
        DELIVERED("Delivered"),
        READ("Read"),
        FAILED("Failed"),
        PUBLISHED("Published"),
        REMOVED("Removed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXT("Text"),
        RECEIPT("Receipt"),
        EVENT("Event");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

