/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class MediaUtilization
implements Serializable {
    private Integer maximumCapacity = null;
    private List<String> interruptableMediaTypes = null;
    private Boolean includeNonAcd = null;

    public MediaUtilization maximumCapacity(Integer maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines the maximum number of conversations of this type that an agent can handle at one time.")
    @JsonProperty(value="maximumCapacity")
    public Integer getMaximumCapacity() {
        return this.maximumCapacity;
    }

    public void setMaximumCapacity(Integer maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
    }

    public MediaUtilization interruptableMediaTypes(List<String> interruptableMediaTypes) {
        this.interruptableMediaTypes = interruptableMediaTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines the list of other media types that can interrupt a conversation of this media type.  Values include call, chat, email, callback, and message.")
    @JsonProperty(value="interruptableMediaTypes")
    public List<String> getInterruptableMediaTypes() {
        return this.interruptableMediaTypes;
    }

    public void setInterruptableMediaTypes(List<String> interruptableMediaTypes) {
        this.interruptableMediaTypes = interruptableMediaTypes;
    }

    public MediaUtilization includeNonAcd(Boolean includeNonAcd) {
        this.includeNonAcd = includeNonAcd;
        return this;
    }

    @ApiModelProperty(example="null", value="If true, then track non-ACD conversations against utilization")
    @JsonProperty(value="includeNonAcd")
    public Boolean getIncludeNonAcd() {
        return this.includeNonAcd;
    }

    public void setIncludeNonAcd(Boolean includeNonAcd) {
        this.includeNonAcd = includeNonAcd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaUtilization mediaUtilization = (MediaUtilization)o;
        return Objects.equals(this.maximumCapacity, mediaUtilization.maximumCapacity) && Objects.equals(this.interruptableMediaTypes, mediaUtilization.interruptableMediaTypes) && Objects.equals(this.includeNonAcd, mediaUtilization.includeNonAcd);
    }

    public int hashCode() {
        return Objects.hash(this.maximumCapacity, this.interruptableMediaTypes, this.includeNonAcd);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaUtilization {\n");
        sb.append("    maximumCapacity: ").append(this.toIndentedString(this.maximumCapacity)).append("\n");
        sb.append("    interruptableMediaTypes: ").append(this.toIndentedString(this.interruptableMediaTypes)).append("\n");
        sb.append("    includeNonAcd: ").append(this.toIndentedString(this.includeNonAcd)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

