/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.MediaType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Media type access definitions")
public class MediaTypeAccess
implements Serializable {
    private List<MediaType> inbound = null;
    private List<MediaType> outbound = null;

    public MediaTypeAccess inbound(List<MediaType> inbound) {
        this.inbound = inbound;
        return this;
    }

    @ApiModelProperty(example="null", value="List of media types allowed for inbound messages from customers. If inbound messages from a customer contain media that is not in this list, the media will be dropped from the outbound message.")
    @JsonProperty(value="inbound")
    public List<MediaType> getInbound() {
        return this.inbound;
    }

    public void setInbound(List<MediaType> inbound) {
        this.inbound = inbound;
    }

    public MediaTypeAccess outbound(List<MediaType> outbound) {
        this.outbound = outbound;
        return this;
    }

    @ApiModelProperty(example="null", value="List of media types allowed for outbound messages to customers. If an outbound message is sent that contains media that is not in this list, the message will not be sent.")
    @JsonProperty(value="outbound")
    public List<MediaType> getOutbound() {
        return this.outbound;
    }

    public void setOutbound(List<MediaType> outbound) {
        this.outbound = outbound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaTypeAccess mediaTypeAccess = (MediaTypeAccess)o;
        return Objects.equals(this.inbound, mediaTypeAccess.inbound) && Objects.equals(this.outbound, mediaTypeAccess.outbound);
    }

    public int hashCode() {
        return Objects.hash(this.inbound, this.outbound);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaTypeAccess {\n");
        sb.append("    inbound: ").append(this.toIndentedString(this.inbound)).append("\n");
        sb.append("    outbound: ").append(this.toIndentedString(this.outbound)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

