/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.LocationAddress;
import com.mypurecloud.sdk.v2.model.LocationAddressVerificationDetails;
import com.mypurecloud.sdk.v2.model.LocationEmergencyNumber;
import com.mypurecloud.sdk.v2.model.LocationImage;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class LocationDefinition
implements Serializable {
    private String id = null;
    private String name = null;
    private AddressableEntityRef contactUser = null;
    private LocationEmergencyNumber emergencyNumber = null;
    private LocationAddress address = null;
    private StateEnum state = null;
    private String notes = null;
    private Integer version = null;
    private List<String> path = null;
    private List<LocationImage> profileImage = null;
    private List<LocationImage> floorplanImage = null;
    private LocationAddressVerificationDetails addressVerificationDetails = null;
    private Boolean addressVerified = null;
    private Boolean addressStored = null;
    private String images = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public LocationDefinition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocationDefinition contactUser(AddressableEntityRef contactUser) {
        this.contactUser = contactUser;
        return this;
    }

    @ApiModelProperty(example="null", value="Site contact for the location entity")
    @JsonProperty(value="contactUser")
    public AddressableEntityRef getContactUser() {
        return this.contactUser;
    }

    public void setContactUser(AddressableEntityRef contactUser) {
        this.contactUser = contactUser;
    }

    public LocationDefinition emergencyNumber(LocationEmergencyNumber emergencyNumber) {
        this.emergencyNumber = emergencyNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Emergency number for the location entity")
    @JsonProperty(value="emergencyNumber")
    public LocationEmergencyNumber getEmergencyNumber() {
        return this.emergencyNumber;
    }

    public void setEmergencyNumber(LocationEmergencyNumber emergencyNumber) {
        this.emergencyNumber = emergencyNumber;
    }

    public LocationDefinition address(LocationAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="address")
    public LocationAddress getAddress() {
        return this.address;
    }

    public void setAddress(LocationAddress address) {
        this.address = address;
    }

    public LocationDefinition state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="Current state of the location entity")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public LocationDefinition notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="null", value="Notes for the location entity")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public LocationDefinition version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Current version of the location entity, value to be supplied should be retrieved by a GET or on create/update response")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="A list of ancestor IDs in order")
    @JsonProperty(value="path")
    public List<String> getPath() {
        return this.path;
    }

    @ApiModelProperty(example="null", value="Profile image of the location entity, retrieved with ?expand=images query parameter")
    @JsonProperty(value="profileImage")
    public List<LocationImage> getProfileImage() {
        return this.profileImage;
    }

    @ApiModelProperty(example="null", value="Floorplan images of the location entity, retrieved with ?expand=images query parameter")
    @JsonProperty(value="floorplanImage")
    public List<LocationImage> getFloorplanImage() {
        return this.floorplanImage;
    }

    @ApiModelProperty(example="null", value="Address verification information, retrieve dwith the ?expand=addressVerificationDetails query parameter")
    @JsonProperty(value="addressVerificationDetails")
    public LocationAddressVerificationDetails getAddressVerificationDetails() {
        return this.addressVerificationDetails;
    }

    @ApiModelProperty(example="null", value="Boolean field which states if the address has been verified as an actual address")
    @JsonProperty(value="addressVerified")
    public Boolean getAddressVerified() {
        return this.addressVerified;
    }

    @ApiModelProperty(example="null", value="Boolean field which states if the address has been stored for E911")
    @JsonProperty(value="addressStored")
    public Boolean getAddressStored() {
        return this.addressStored;
    }

    public LocationDefinition images(String images) {
        this.images = images;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="images")
    public String getImages() {
        return this.images;
    }

    public void setImages(String images) {
        this.images = images;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationDefinition locationDefinition = (LocationDefinition)o;
        return Objects.equals(this.id, locationDefinition.id) && Objects.equals(this.name, locationDefinition.name) && Objects.equals(this.contactUser, locationDefinition.contactUser) && Objects.equals(this.emergencyNumber, locationDefinition.emergencyNumber) && Objects.equals(this.address, locationDefinition.address) && Objects.equals((Object)this.state, (Object)locationDefinition.state) && Objects.equals(this.notes, locationDefinition.notes) && Objects.equals(this.version, locationDefinition.version) && Objects.equals(this.path, locationDefinition.path) && Objects.equals(this.profileImage, locationDefinition.profileImage) && Objects.equals(this.floorplanImage, locationDefinition.floorplanImage) && Objects.equals(this.addressVerificationDetails, locationDefinition.addressVerificationDetails) && Objects.equals(this.addressVerified, locationDefinition.addressVerified) && Objects.equals(this.addressStored, locationDefinition.addressStored) && Objects.equals(this.images, locationDefinition.images) && Objects.equals(this.selfUri, locationDefinition.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.contactUser, this.emergencyNumber, this.address, this.state, this.notes, this.version, this.path, this.profileImage, this.floorplanImage, this.addressVerificationDetails, this.addressVerified, this.addressStored, this.images, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocationDefinition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    contactUser: ").append(this.toIndentedString(this.contactUser)).append("\n");
        sb.append("    emergencyNumber: ").append(this.toIndentedString(this.emergencyNumber)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    profileImage: ").append(this.toIndentedString(this.profileImage)).append("\n");
        sb.append("    floorplanImage: ").append(this.toIndentedString(this.floorplanImage)).append("\n");
        sb.append("    addressVerificationDetails: ").append(this.toIndentedString(this.addressVerificationDetails)).append("\n");
        sb.append("    addressVerified: ").append(this.toIndentedString(this.addressVerified)).append("\n");
        sb.append("    addressStored: ").append(this.toIndentedString(this.addressStored)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

