/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;

public class IntradayPlanningGroupRequest
implements Serializable {
    private LocalDate businessUnitDate = null;
    private List<CategoriesEnum> categories = null;
    private List<String> planningGroupIds = null;
    private Integer intervalLengthMinutes = null;

    public IntradayPlanningGroupRequest businessUnitDate(LocalDate businessUnitDate) {
        this.businessUnitDate = businessUnitDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Requested date in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="businessUnitDate")
    public LocalDate getBusinessUnitDate() {
        return this.businessUnitDate;
    }

    public void setBusinessUnitDate(LocalDate businessUnitDate) {
        this.businessUnitDate = businessUnitDate;
    }

    public IntradayPlanningGroupRequest categories(List<CategoriesEnum> categories) {
        this.categories = categories;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The metric categories")
    @JsonProperty(value="categories")
    public List<CategoriesEnum> getCategories() {
        return this.categories;
    }

    public void setCategories(List<CategoriesEnum> categories) {
        this.categories = categories;
    }

    public IntradayPlanningGroupRequest planningGroupIds(List<String> planningGroupIds) {
        this.planningGroupIds = planningGroupIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of the planning groups for which to fetch data.  Omitting or passing an empty list will return all available planning groups")
    @JsonProperty(value="planningGroupIds")
    public List<String> getPlanningGroupIds() {
        return this.planningGroupIds;
    }

    public void setPlanningGroupIds(List<String> planningGroupIds) {
        this.planningGroupIds = planningGroupIds;
    }

    public IntradayPlanningGroupRequest intervalLengthMinutes(Integer intervalLengthMinutes) {
        this.intervalLengthMinutes = intervalLengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The period/interval in minutes for which to aggregate the data. Required, defaults to 15")
    @JsonProperty(value="intervalLengthMinutes")
    public Integer getIntervalLengthMinutes() {
        return this.intervalLengthMinutes;
    }

    public void setIntervalLengthMinutes(Integer intervalLengthMinutes) {
        this.intervalLengthMinutes = intervalLengthMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntradayPlanningGroupRequest intradayPlanningGroupRequest = (IntradayPlanningGroupRequest)o;
        return Objects.equals(this.businessUnitDate, intradayPlanningGroupRequest.businessUnitDate) && Objects.equals(this.categories, intradayPlanningGroupRequest.categories) && Objects.equals(this.planningGroupIds, intradayPlanningGroupRequest.planningGroupIds) && Objects.equals(this.intervalLengthMinutes, intradayPlanningGroupRequest.intervalLengthMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.businessUnitDate, this.categories, this.planningGroupIds, this.intervalLengthMinutes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntradayPlanningGroupRequest {\n");
        sb.append("    businessUnitDate: ").append(this.toIndentedString(this.businessUnitDate)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    planningGroupIds: ").append(this.toIndentedString(this.planningGroupIds)).append("\n");
        sb.append("    intervalLengthMinutes: ").append(this.toIndentedString(this.intervalLengthMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CategoriesEnumDeserializer.class)
    public static enum CategoriesEnum {
        FORECASTDATA("ForecastData"),
        SCHEDULEDATA("ScheduleData"),
        PERFORMANCEPREDICTIONDATA("PerformancePredictionData");

        private String value;

        private CategoriesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CategoriesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CategoriesEnum value : CategoriesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CategoriesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CategoriesEnumDeserializer
    extends StdDeserializer<CategoriesEnum> {
        public CategoriesEnumDeserializer() {
            super(CategoriesEnumDeserializer.class);
        }

        public CategoriesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CategoriesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

