/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.GroupContact;
import com.mypurecloud.sdk.v2.model.UserImage;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class GroupUpdate
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private StateEnum state = null;
    private Integer version = null;
    private List<UserImage> images = null;
    private List<GroupContact> addresses = null;
    private Boolean rulesVisible = null;
    private VisibilityEnum visibility = null;
    private List<String> ownerIds = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public GroupUpdate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The group name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GroupUpdate description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GroupUpdate state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="State of the group.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public GroupUpdate version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Current version for this resource.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public GroupUpdate images(List<UserImage> images) {
        this.images = images;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="images")
    public List<UserImage> getImages() {
        return this.images;
    }

    public void setImages(List<UserImage> images) {
        this.images = images;
    }

    public GroupUpdate addresses(List<GroupContact> addresses) {
        this.addresses = addresses;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="addresses")
    public List<GroupContact> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<GroupContact> addresses) {
        this.addresses = addresses;
    }

    public GroupUpdate rulesVisible(Boolean rulesVisible) {
        this.rulesVisible = rulesVisible;
        return this;
    }

    @ApiModelProperty(example="null", value="Are membership rules visible to the person requesting to view the group")
    @JsonProperty(value="rulesVisible")
    public Boolean getRulesVisible() {
        return this.rulesVisible;
    }

    public void setRulesVisible(Boolean rulesVisible) {
        this.rulesVisible = rulesVisible;
    }

    public GroupUpdate visibility(VisibilityEnum visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(example="null", value="Who can view this group")
    @JsonProperty(value="visibility")
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityEnum visibility) {
        this.visibility = visibility;
    }

    public GroupUpdate ownerIds(List<String> ownerIds) {
        this.ownerIds = ownerIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Owners of the group")
    @JsonProperty(value="ownerIds")
    public List<String> getOwnerIds() {
        return this.ownerIds;
    }

    public void setOwnerIds(List<String> ownerIds) {
        this.ownerIds = ownerIds;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupUpdate groupUpdate = (GroupUpdate)o;
        return Objects.equals(this.id, groupUpdate.id) && Objects.equals(this.name, groupUpdate.name) && Objects.equals(this.description, groupUpdate.description) && Objects.equals((Object)this.state, (Object)groupUpdate.state) && Objects.equals(this.version, groupUpdate.version) && Objects.equals(this.images, groupUpdate.images) && Objects.equals(this.addresses, groupUpdate.addresses) && Objects.equals(this.rulesVisible, groupUpdate.rulesVisible) && Objects.equals((Object)this.visibility, (Object)groupUpdate.visibility) && Objects.equals(this.ownerIds, groupUpdate.ownerIds) && Objects.equals(this.selfUri, groupUpdate.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.state, this.version, this.images, this.addresses, this.rulesVisible, this.visibility, this.ownerIds, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupUpdate {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    rulesVisible: ").append(this.toIndentedString(this.rulesVisible)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("    ownerIds: ").append(this.toIndentedString(this.ownerIds)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=VisibilityEnumDeserializer.class)
    public static enum VisibilityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PUBLIC("public"),
        OWNERIDS("ownerIds"),
        MEMBERS("members");

        private String value;

        private VisibilityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static VisibilityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (VisibilityEnum value : VisibilityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return VisibilityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class VisibilityEnumDeserializer
    extends StdDeserializer<VisibilityEnum> {
        public VisibilityEnumDeserializer() {
            super(VisibilityEnumDeserializer.class);
        }

        public VisibilityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return VisibilityEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

