/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The Footer template identifies the Footer type and its footerUsage")
public class FooterTemplate
implements Serializable {
    private TypeEnum type = null;
    private List<ApplicableResourcesEnum> applicableResources = null;

    public FooterTemplate type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the type represented by Footer.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FooterTemplate applicableResources(List<ApplicableResourcesEnum> applicableResources) {
        this.applicableResources = applicableResources;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the canned response template where the footer can be used.")
    @JsonProperty(value="applicableResources")
    public List<ApplicableResourcesEnum> getApplicableResources() {
        return this.applicableResources;
    }

    public void setApplicableResources(List<ApplicableResourcesEnum> applicableResources) {
        this.applicableResources = applicableResources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FooterTemplate footerTemplate = (FooterTemplate)o;
        return Objects.equals((Object)this.type, (Object)footerTemplate.type) && Objects.equals(this.applicableResources, footerTemplate.applicableResources);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.applicableResources});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FooterTemplate {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    applicableResources: ").append(this.toIndentedString(this.applicableResources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ApplicableResourcesEnumDeserializer.class)
    public static enum ApplicableResourcesEnum {
        CAMPAIGN("Campaign");

        private String value;

        private ApplicableResourcesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ApplicableResourcesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ApplicableResourcesEnum value : ApplicableResourcesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ApplicableResourcesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ApplicableResourcesEnumDeserializer
    extends StdDeserializer<ApplicableResourcesEnum> {
        public ApplicableResourcesEnumDeserializer() {
            super(ApplicableResourcesEnumDeserializer.class);
        }

        public ApplicableResourcesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ApplicableResourcesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SIGNATURE("Signature");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

