/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

public class ExternalMetricDataItem
implements Serializable {
    private String userId = null;
    private String userEmail = null;
    private String metricId = null;
    private LocalDate dateOccurred = null;
    private BigDecimal value = null;
    private Integer count = null;

    public ExternalMetricDataItem userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="The user ID. Must provide either userId or userEmail, but not both.")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ExternalMetricDataItem userEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    @ApiModelProperty(example="null", value="The user main email used in user's GenesysCloud account. Must provide either userId or userEmail, but not both.")
    @JsonProperty(value="userEmail")
    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public ExternalMetricDataItem metricId(String metricId) {
        this.metricId = metricId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the external metric definition")
    @JsonProperty(value="metricId")
    public String getMetricId() {
        return this.metricId;
    }

    public void setMetricId(String metricId) {
        this.metricId = metricId;
    }

    public ExternalMetricDataItem dateOccurred(LocalDate dateOccurred) {
        this.dateOccurred = dateOccurred;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date of the metric data. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateOccurred")
    public LocalDate getDateOccurred() {
        return this.dateOccurred;
    }

    public void setDateOccurred(LocalDate dateOccurred) {
        this.dateOccurred = dateOccurred;
    }

    public ExternalMetricDataItem value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The value of the metric data. When value is null, the metric data will be deleted.")
    @JsonProperty(value="value")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public ExternalMetricDataItem count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of data points. The default value is 1.")
    @JsonProperty(value="count")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalMetricDataItem externalMetricDataItem = (ExternalMetricDataItem)o;
        return Objects.equals(this.userId, externalMetricDataItem.userId) && Objects.equals(this.userEmail, externalMetricDataItem.userEmail) && Objects.equals(this.metricId, externalMetricDataItem.metricId) && Objects.equals(this.dateOccurred, externalMetricDataItem.dateOccurred) && Objects.equals(this.value, externalMetricDataItem.value) && Objects.equals(this.count, externalMetricDataItem.count);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.userEmail, this.metricId, this.dateOccurred, this.value, this.count);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalMetricDataItem {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userEmail: ").append(this.toIndentedString(this.userEmail)).append("\n");
        sb.append("    metricId: ").append(this.toIndentedString(this.metricId)).append("\n");
        sb.append("    dateOccurred: ").append(this.toIndentedString(this.dateOccurred)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

