/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Attachment;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class CopyAttachmentsRequest
implements Serializable {
    private DomainEntityRef sourceMessage = null;
    private List<Attachment> attachments = null;

    public CopyAttachmentsRequest sourceMessage(DomainEntityRef sourceMessage) {
        this.sourceMessage = sourceMessage;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A reference to the email message within the current conversation that owns the attachments to be copied")
    @JsonProperty(value="sourceMessage")
    public DomainEntityRef getSourceMessage() {
        return this.sourceMessage;
    }

    public void setSourceMessage(DomainEntityRef sourceMessage) {
        this.sourceMessage = sourceMessage;
    }

    public CopyAttachmentsRequest attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A list of attachments that will be copied from the source message to the current draft")
    @JsonProperty(value="attachments")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyAttachmentsRequest copyAttachmentsRequest = (CopyAttachmentsRequest)o;
        return Objects.equals(this.sourceMessage, copyAttachmentsRequest.sourceMessage) && Objects.equals(this.attachments, copyAttachmentsRequest.attachments);
    }

    public int hashCode() {
        return Objects.hash(this.sourceMessage, this.attachments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CopyAttachmentsRequest {\n");
        sb.append("    sourceMessage: ").append(this.toIndentedString(this.sourceMessage)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

