/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.CallRoute;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CallForwarding
implements Serializable {
    private String id = null;
    private String name = null;
    private User user = null;
    private Boolean enabled = null;
    private String phoneNumber = null;
    private List<CallRoute> calls = null;
    private VoicemailEnum voicemail = null;
    private Date modifiedDate = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public CallForwarding name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CallForwarding user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public CallForwarding enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not CallForwarding is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CallForwarding phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="This property is deprecated. Please use the calls property")
    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public CallForwarding calls(List<CallRoute> calls) {
        this.calls = calls;
        return this;
    }

    @ApiModelProperty(example="null", value="An ordered list of CallRoutes to be executed when CallForwarding is enabled")
    @JsonProperty(value="calls")
    public List<CallRoute> getCalls() {
        return this.calls;
    }

    public void setCalls(List<CallRoute> calls) {
        this.calls = calls;
    }

    public CallForwarding voicemail(VoicemailEnum voicemail) {
        this.voicemail = voicemail;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of voicemail to use with the callForwarding configuration")
    @JsonProperty(value="voicemail")
    public VoicemailEnum getVoicemail() {
        return this.voicemail;
    }

    public void setVoicemail(VoicemailEnum voicemail) {
        this.voicemail = voicemail;
    }

    public CallForwarding modifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="modifiedDate")
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallForwarding callForwarding = (CallForwarding)o;
        return Objects.equals(this.id, callForwarding.id) && Objects.equals(this.name, callForwarding.name) && Objects.equals(this.user, callForwarding.user) && Objects.equals(this.enabled, callForwarding.enabled) && Objects.equals(this.phoneNumber, callForwarding.phoneNumber) && Objects.equals(this.calls, callForwarding.calls) && Objects.equals((Object)this.voicemail, (Object)callForwarding.voicemail) && Objects.equals(this.modifiedDate, callForwarding.modifiedDate) && Objects.equals(this.selfUri, callForwarding.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.user, this.enabled, this.phoneNumber, this.calls, this.voicemail, this.modifiedDate, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallForwarding {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    calls: ").append(this.toIndentedString(this.calls)).append("\n");
        sb.append("    voicemail: ").append(this.toIndentedString((Object)this.voicemail)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=VoicemailEnumDeserializer.class)
    public static enum VoicemailEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PURECLOUD("PURECLOUD"),
        LASTCALL("LASTCALL"),
        NONE("NONE");

        private String value;

        private VoicemailEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static VoicemailEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (VoicemailEnum value : VoicemailEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return VoicemailEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class VoicemailEnumDeserializer
    extends StdDeserializer<VoicemailEnum> {
        public VoicemailEnumDeserializer() {
            super(VoicemailEnumDeserializer.class);
        }

        public VoicemailEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return VoicemailEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

