/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.BuForecastGenerationResult;
import com.mypurecloud.sdk.v2.model.BuForecastModification;
import com.mypurecloud.sdk.v2.model.ForecastPlanningGroupsResponse;
import com.mypurecloud.sdk.v2.model.ForecastSourceDayPointer;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class BuShortTermForecast
implements Serializable {
    private String id = null;
    private LocalDate weekDate = null;
    private Integer weekCount = null;
    private CreationMethodEnum creationMethod = null;
    private String description = null;
    private Boolean legacy = null;
    private WfmVersionedEntityMetadata metadata = null;
    private Boolean canUseForScheduling = null;
    private Date referenceStartDate = null;
    private List<ForecastSourceDayPointer> sourceDays = null;
    private List<BuForecastModification> modifications = null;
    private BuForecastGenerationResult generationResults = null;
    private String timeZone = null;
    private Integer planningGroupsVersion = null;
    private ForecastPlanningGroupsResponse planningGroups = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public BuShortTermForecast weekDate(LocalDate weekDate) {
        this.weekDate = weekDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start week date of this forecast in yyyy-MM-dd.  Must fall on the start day of week for the associated business unit. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="weekDate")
    public LocalDate getWeekDate() {
        return this.weekDate;
    }

    public void setWeekDate(LocalDate weekDate) {
        this.weekDate = weekDate;
    }

    public BuShortTermForecast weekCount(Integer weekCount) {
        this.weekCount = weekCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of weeks this forecast covers")
    @JsonProperty(value="weekCount")
    public Integer getWeekCount() {
        return this.weekCount;
    }

    public void setWeekCount(Integer weekCount) {
        this.weekCount = weekCount;
    }

    public BuShortTermForecast creationMethod(CreationMethodEnum creationMethod) {
        this.creationMethod = creationMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="The method by which this forecast was created")
    @JsonProperty(value="creationMethod")
    public CreationMethodEnum getCreationMethod() {
        return this.creationMethod;
    }

    public void setCreationMethod(CreationMethodEnum creationMethod) {
        this.creationMethod = creationMethod;
    }

    public BuShortTermForecast description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of this forecast")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="null", value="Whether this forecast contains modifications on legacy metrics")
    @JsonProperty(value="legacy")
    public Boolean getLegacy() {
        return this.legacy;
    }

    public BuShortTermForecast metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Metadata for this forecast")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public BuShortTermForecast canUseForScheduling(Boolean canUseForScheduling) {
        this.canUseForScheduling = canUseForScheduling;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this forecast can be used for scheduling")
    @JsonProperty(value="canUseForScheduling")
    public Boolean getCanUseForScheduling() {
        return this.canUseForScheduling;
    }

    public void setCanUseForScheduling(Boolean canUseForScheduling) {
        this.canUseForScheduling = canUseForScheduling;
    }

    public BuShortTermForecast referenceStartDate(Date referenceStartDate) {
        this.referenceStartDate = referenceStartDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The reference start date for interval-based data for this forecast. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="referenceStartDate")
    public Date getReferenceStartDate() {
        return this.referenceStartDate;
    }

    public void setReferenceStartDate(Date referenceStartDate) {
        this.referenceStartDate = referenceStartDate;
    }

    public BuShortTermForecast sourceDays(List<ForecastSourceDayPointer> sourceDays) {
        this.sourceDays = sourceDays;
        return this;
    }

    @ApiModelProperty(example="null", value="The source day pointers for this forecast")
    @JsonProperty(value="sourceDays")
    public List<ForecastSourceDayPointer> getSourceDays() {
        return this.sourceDays;
    }

    public void setSourceDays(List<ForecastSourceDayPointer> sourceDays) {
        this.sourceDays = sourceDays;
    }

    public BuShortTermForecast modifications(List<BuForecastModification> modifications) {
        this.modifications = modifications;
        return this;
    }

    @ApiModelProperty(example="null", value="Any manual modifications applied to this forecast")
    @JsonProperty(value="modifications")
    public List<BuForecastModification> getModifications() {
        return this.modifications;
    }

    public void setModifications(List<BuForecastModification> modifications) {
        this.modifications = modifications;
    }

    public BuShortTermForecast generationResults(BuForecastGenerationResult generationResults) {
        this.generationResults = generationResults;
        return this;
    }

    @ApiModelProperty(example="null", value="Generation result metadata")
    @JsonProperty(value="generationResults")
    public BuForecastGenerationResult getGenerationResults() {
        return this.generationResults;
    }

    public void setGenerationResults(BuForecastGenerationResult generationResults) {
        this.generationResults = generationResults;
    }

    public BuShortTermForecast timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="The time zone for this forecast")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public BuShortTermForecast planningGroupsVersion(Integer planningGroupsVersion) {
        this.planningGroupsVersion = planningGroupsVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of the planning groups that was used for this forecast")
    @JsonProperty(value="planningGroupsVersion")
    public Integer getPlanningGroupsVersion() {
        return this.planningGroupsVersion;
    }

    public void setPlanningGroupsVersion(Integer planningGroupsVersion) {
        this.planningGroupsVersion = planningGroupsVersion;
    }

    public BuShortTermForecast planningGroups(ForecastPlanningGroupsResponse planningGroups) {
        this.planningGroups = planningGroups;
        return this;
    }

    @ApiModelProperty(example="null", value="A snapshot of the planning groups used for this forecast as of the version number indicated")
    @JsonProperty(value="planningGroups")
    public ForecastPlanningGroupsResponse getPlanningGroups() {
        return this.planningGroups;
    }

    public void setPlanningGroups(ForecastPlanningGroupsResponse planningGroups) {
        this.planningGroups = planningGroups;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuShortTermForecast buShortTermForecast = (BuShortTermForecast)o;
        return Objects.equals(this.id, buShortTermForecast.id) && Objects.equals(this.weekDate, buShortTermForecast.weekDate) && Objects.equals(this.weekCount, buShortTermForecast.weekCount) && Objects.equals((Object)this.creationMethod, (Object)buShortTermForecast.creationMethod) && Objects.equals(this.description, buShortTermForecast.description) && Objects.equals(this.legacy, buShortTermForecast.legacy) && Objects.equals(this.metadata, buShortTermForecast.metadata) && Objects.equals(this.canUseForScheduling, buShortTermForecast.canUseForScheduling) && Objects.equals(this.referenceStartDate, buShortTermForecast.referenceStartDate) && Objects.equals(this.sourceDays, buShortTermForecast.sourceDays) && Objects.equals(this.modifications, buShortTermForecast.modifications) && Objects.equals(this.generationResults, buShortTermForecast.generationResults) && Objects.equals(this.timeZone, buShortTermForecast.timeZone) && Objects.equals(this.planningGroupsVersion, buShortTermForecast.planningGroupsVersion) && Objects.equals(this.planningGroups, buShortTermForecast.planningGroups) && Objects.equals(this.selfUri, buShortTermForecast.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.weekDate, this.weekCount, this.creationMethod, this.description, this.legacy, this.metadata, this.canUseForScheduling, this.referenceStartDate, this.sourceDays, this.modifications, this.generationResults, this.timeZone, this.planningGroupsVersion, this.planningGroups, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuShortTermForecast {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    weekDate: ").append(this.toIndentedString(this.weekDate)).append("\n");
        sb.append("    weekCount: ").append(this.toIndentedString(this.weekCount)).append("\n");
        sb.append("    creationMethod: ").append(this.toIndentedString((Object)this.creationMethod)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    legacy: ").append(this.toIndentedString(this.legacy)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    canUseForScheduling: ").append(this.toIndentedString(this.canUseForScheduling)).append("\n");
        sb.append("    referenceStartDate: ").append(this.toIndentedString(this.referenceStartDate)).append("\n");
        sb.append("    sourceDays: ").append(this.toIndentedString(this.sourceDays)).append("\n");
        sb.append("    modifications: ").append(this.toIndentedString(this.modifications)).append("\n");
        sb.append("    generationResults: ").append(this.toIndentedString(this.generationResults)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    planningGroupsVersion: ").append(this.toIndentedString(this.planningGroupsVersion)).append("\n");
        sb.append("    planningGroups: ").append(this.toIndentedString(this.planningGroups)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CreationMethodEnumDeserializer.class)
    public static enum CreationMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IMPORT("Import"),
        IMPORTEDHISTORICALWEIGHTEDAVERAGE("ImportedHistoricalWeightedAverage"),
        HISTORICALWEIGHTEDAVERAGE("HistoricalWeightedAverage"),
        ADVANCED("Advanced");

        private String value;

        private CreationMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CreationMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CreationMethodEnum value : CreationMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CreationMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CreationMethodEnumDeserializer
    extends StdDeserializer<CreationMethodEnum> {
        public CreationMethodEnumDeserializer() {
            super(CreationMethodEnumDeserializer.class);
        }

        public CreationMethodEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CreationMethodEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

