/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class BuRescheduleRequest
implements Serializable {
    private Date startDate = null;
    private Date endDate = null;
    private List<String> agentIds = null;
    private List<String> activityCodeIds = null;
    private List<String> managementUnitIds = null;
    private Boolean doNotChangeWeeklyPaidTime = null;
    private Boolean doNotChangeDailyPaidTime = null;
    private Boolean doNotChangeShiftStartTimes = null;
    private Boolean doNotChangeManuallyEditedShifts = null;

    public BuRescheduleRequest startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start of the range to reschedule.  Defaults to the beginning of the schedule. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public BuRescheduleRequest endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The end of the range to reschedule.  Defaults the the end of the schedule. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BuRescheduleRequest agentIds(List<String> agentIds) {
        this.agentIds = agentIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of the agents to consider for rescheduling.  Omit to consider all agents in the specified management units.Agents not in the specified management units will be ignored")
    @JsonProperty(value="agentIds")
    public List<String> getAgentIds() {
        return this.agentIds;
    }

    public void setAgentIds(List<String> agentIds) {
        this.agentIds = agentIds;
    }

    public BuRescheduleRequest activityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of the activity codes to consider for rescheduling.  Omit to consider all activity codes")
    @JsonProperty(value="activityCodeIds")
    public List<String> getActivityCodeIds() {
        return this.activityCodeIds;
    }

    public void setActivityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
    }

    public BuRescheduleRequest managementUnitIds(List<String> managementUnitIds) {
        this.managementUnitIds = managementUnitIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The IDs of the management units to reschedule")
    @JsonProperty(value="managementUnitIds")
    public List<String> getManagementUnitIds() {
        return this.managementUnitIds;
    }

    public void setManagementUnitIds(List<String> managementUnitIds) {
        this.managementUnitIds = managementUnitIds;
    }

    public BuRescheduleRequest doNotChangeWeeklyPaidTime(Boolean doNotChangeWeeklyPaidTime) {
        this.doNotChangeWeeklyPaidTime = doNotChangeWeeklyPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Instructs the scheduler whether it is allowed to change weekly paid time")
    @JsonProperty(value="doNotChangeWeeklyPaidTime")
    public Boolean getDoNotChangeWeeklyPaidTime() {
        return this.doNotChangeWeeklyPaidTime;
    }

    public void setDoNotChangeWeeklyPaidTime(Boolean doNotChangeWeeklyPaidTime) {
        this.doNotChangeWeeklyPaidTime = doNotChangeWeeklyPaidTime;
    }

    public BuRescheduleRequest doNotChangeDailyPaidTime(Boolean doNotChangeDailyPaidTime) {
        this.doNotChangeDailyPaidTime = doNotChangeDailyPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Instructs the scheduler whether it is allowed to change daily paid time")
    @JsonProperty(value="doNotChangeDailyPaidTime")
    public Boolean getDoNotChangeDailyPaidTime() {
        return this.doNotChangeDailyPaidTime;
    }

    public void setDoNotChangeDailyPaidTime(Boolean doNotChangeDailyPaidTime) {
        this.doNotChangeDailyPaidTime = doNotChangeDailyPaidTime;
    }

    public BuRescheduleRequest doNotChangeShiftStartTimes(Boolean doNotChangeShiftStartTimes) {
        this.doNotChangeShiftStartTimes = doNotChangeShiftStartTimes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Instructs the scheduler whether it is allowed to change shift start times")
    @JsonProperty(value="doNotChangeShiftStartTimes")
    public Boolean getDoNotChangeShiftStartTimes() {
        return this.doNotChangeShiftStartTimes;
    }

    public void setDoNotChangeShiftStartTimes(Boolean doNotChangeShiftStartTimes) {
        this.doNotChangeShiftStartTimes = doNotChangeShiftStartTimes;
    }

    public BuRescheduleRequest doNotChangeManuallyEditedShifts(Boolean doNotChangeManuallyEditedShifts) {
        this.doNotChangeManuallyEditedShifts = doNotChangeManuallyEditedShifts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Instructs the scheduler whether it is allowed to change manually edited shifts")
    @JsonProperty(value="doNotChangeManuallyEditedShifts")
    public Boolean getDoNotChangeManuallyEditedShifts() {
        return this.doNotChangeManuallyEditedShifts;
    }

    public void setDoNotChangeManuallyEditedShifts(Boolean doNotChangeManuallyEditedShifts) {
        this.doNotChangeManuallyEditedShifts = doNotChangeManuallyEditedShifts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuRescheduleRequest buRescheduleRequest = (BuRescheduleRequest)o;
        return Objects.equals(this.startDate, buRescheduleRequest.startDate) && Objects.equals(this.endDate, buRescheduleRequest.endDate) && Objects.equals(this.agentIds, buRescheduleRequest.agentIds) && Objects.equals(this.activityCodeIds, buRescheduleRequest.activityCodeIds) && Objects.equals(this.managementUnitIds, buRescheduleRequest.managementUnitIds) && Objects.equals(this.doNotChangeWeeklyPaidTime, buRescheduleRequest.doNotChangeWeeklyPaidTime) && Objects.equals(this.doNotChangeDailyPaidTime, buRescheduleRequest.doNotChangeDailyPaidTime) && Objects.equals(this.doNotChangeShiftStartTimes, buRescheduleRequest.doNotChangeShiftStartTimes) && Objects.equals(this.doNotChangeManuallyEditedShifts, buRescheduleRequest.doNotChangeManuallyEditedShifts);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.agentIds, this.activityCodeIds, this.managementUnitIds, this.doNotChangeWeeklyPaidTime, this.doNotChangeDailyPaidTime, this.doNotChangeShiftStartTimes, this.doNotChangeManuallyEditedShifts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuRescheduleRequest {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    agentIds: ").append(this.toIndentedString(this.agentIds)).append("\n");
        sb.append("    activityCodeIds: ").append(this.toIndentedString(this.activityCodeIds)).append("\n");
        sb.append("    managementUnitIds: ").append(this.toIndentedString(this.managementUnitIds)).append("\n");
        sb.append("    doNotChangeWeeklyPaidTime: ").append(this.toIndentedString(this.doNotChangeWeeklyPaidTime)).append("\n");
        sb.append("    doNotChangeDailyPaidTime: ").append(this.toIndentedString(this.doNotChangeDailyPaidTime)).append("\n");
        sb.append("    doNotChangeShiftStartTimes: ").append(this.toIndentedString(this.doNotChangeShiftStartTimes)).append("\n");
        sb.append("    doNotChangeManuallyEditedShifts: ").append(this.toIndentedString(this.doNotChangeManuallyEditedShifts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

