/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Conversation;
import com.mypurecloud.sdk.v2.model.Group;
import com.mypurecloud.sdk.v2.model.Queue;
import com.mypurecloud.sdk.v2.model.User;
import com.mypurecloud.sdk.v2.model.VoicemailCopyRecord;
import com.mypurecloud.sdk.v2.model.VoicemailRetentionPolicy;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class VoicemailMessage
implements Serializable {
    private String id = null;
    private Conversation conversation = null;
    private Boolean read = null;
    private Integer audioRecordingDurationSeconds = null;
    private Long audioRecordingSizeBytes = null;
    private Date createdDate = null;
    private Date modifiedDate = null;
    private String callerAddress = null;
    private String callerName = null;
    private User callerUser = null;
    private Boolean deleted = null;
    private String note = null;
    private User user = null;
    private Group group = null;
    private Queue queue = null;
    private VoicemailCopyRecord copiedFrom = null;
    private List<VoicemailCopyRecord> copiedTo = new ArrayList<VoicemailCopyRecord>();
    private VoicemailRetentionPolicy retentionPolicy = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public VoicemailMessage conversation(Conversation conversation) {
        this.conversation = conversation;
        return this;
    }

    @ApiModelProperty(example="null", value="The conversation that the voicemail message is associated with")
    @JsonProperty(value="conversation")
    public Conversation getConversation() {
        return this.conversation;
    }

    public void setConversation(Conversation conversation) {
        this.conversation = conversation;
    }

    public VoicemailMessage read(Boolean read) {
        this.read = read;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the voicemail message is marked as read")
    @JsonProperty(value="read")
    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    @ApiModelProperty(example="null", value="The voicemail message's audio recording duration in seconds")
    @JsonProperty(value="audioRecordingDurationSeconds")
    public Integer getAudioRecordingDurationSeconds() {
        return this.audioRecordingDurationSeconds;
    }

    @ApiModelProperty(example="null", value="The voicemail message's audio recording size in bytes")
    @JsonProperty(value="audioRecordingSizeBytes")
    public Long getAudioRecordingSizeBytes() {
        return this.audioRecordingSizeBytes;
    }

    @ApiModelProperty(example="null", value="The date the voicemail message was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @ApiModelProperty(example="null", value="The date the voicemail message was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="modifiedDate")
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    @ApiModelProperty(example="null", value="The caller address")
    @JsonProperty(value="callerAddress")
    public String getCallerAddress() {
        return this.callerAddress;
    }

    @ApiModelProperty(example="null", value="Optionally the name of the caller that left the voicemail message if the caller was a known user")
    @JsonProperty(value="callerName")
    public String getCallerName() {
        return this.callerName;
    }

    public VoicemailMessage callerUser(User callerUser) {
        this.callerUser = callerUser;
        return this;
    }

    @ApiModelProperty(example="null", value="Optionally the user that left the voicemail message if the caller was a known user")
    @JsonProperty(value="callerUser")
    public User getCallerUser() {
        return this.callerUser;
    }

    public void setCallerUser(User callerUser) {
        this.callerUser = callerUser;
    }

    public VoicemailMessage deleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the voicemail message has been marked as deleted")
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public VoicemailMessage note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(example="null", value="An optional note")
    @JsonProperty(value="note")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public VoicemailMessage user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The user that the voicemail message belongs to or null which means the voicemail message belongs to a group or queue")
    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public VoicemailMessage group(Group group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(example="null", value="The group that the voicemail message belongs to or null which means the voicemail message belongs to a user or queue")
    @JsonProperty(value="group")
    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public VoicemailMessage queue(Queue queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue that the voicemail message belongs to or null which means the voicemail message belongs to a user or group")
    @JsonProperty(value="queue")
    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public VoicemailMessage copiedFrom(VoicemailCopyRecord copiedFrom) {
        this.copiedFrom = copiedFrom;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents where this voicemail message was copied from")
    @JsonProperty(value="copiedFrom")
    public VoicemailCopyRecord getCopiedFrom() {
        return this.copiedFrom;
    }

    public void setCopiedFrom(VoicemailCopyRecord copiedFrom) {
        this.copiedFrom = copiedFrom;
    }

    public VoicemailMessage copiedTo(List<VoicemailCopyRecord> copiedTo) {
        this.copiedTo = copiedTo;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents where this voicemail has been copied to")
    @JsonProperty(value="copiedTo")
    public List<VoicemailCopyRecord> getCopiedTo() {
        return this.copiedTo;
    }

    public void setCopiedTo(List<VoicemailCopyRecord> copiedTo) {
        this.copiedTo = copiedTo;
    }

    public VoicemailMessage retentionPolicy(VoicemailRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    @ApiModelProperty(example="null", value="The retention policy for this voicemail")
    @JsonProperty(value="retentionPolicy")
    public VoicemailRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(VoicemailRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoicemailMessage voicemailMessage = (VoicemailMessage)o;
        return Objects.equals(this.id, voicemailMessage.id) && Objects.equals(this.conversation, voicemailMessage.conversation) && Objects.equals(this.read, voicemailMessage.read) && Objects.equals(this.audioRecordingDurationSeconds, voicemailMessage.audioRecordingDurationSeconds) && Objects.equals(this.audioRecordingSizeBytes, voicemailMessage.audioRecordingSizeBytes) && Objects.equals(this.createdDate, voicemailMessage.createdDate) && Objects.equals(this.modifiedDate, voicemailMessage.modifiedDate) && Objects.equals(this.callerAddress, voicemailMessage.callerAddress) && Objects.equals(this.callerName, voicemailMessage.callerName) && Objects.equals(this.callerUser, voicemailMessage.callerUser) && Objects.equals(this.deleted, voicemailMessage.deleted) && Objects.equals(this.note, voicemailMessage.note) && Objects.equals(this.user, voicemailMessage.user) && Objects.equals(this.group, voicemailMessage.group) && Objects.equals(this.queue, voicemailMessage.queue) && Objects.equals(this.copiedFrom, voicemailMessage.copiedFrom) && Objects.equals(this.copiedTo, voicemailMessage.copiedTo) && Objects.equals(this.retentionPolicy, voicemailMessage.retentionPolicy) && Objects.equals(this.selfUri, voicemailMessage.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.conversation, this.read, this.audioRecordingDurationSeconds, this.audioRecordingSizeBytes, this.createdDate, this.modifiedDate, this.callerAddress, this.callerName, this.callerUser, this.deleted, this.note, this.user, this.group, this.queue, this.copiedFrom, this.copiedTo, this.retentionPolicy, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VoicemailMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        sb.append("    audioRecordingDurationSeconds: ").append(this.toIndentedString(this.audioRecordingDurationSeconds)).append("\n");
        sb.append("    audioRecordingSizeBytes: ").append(this.toIndentedString(this.audioRecordingSizeBytes)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    callerAddress: ").append(this.toIndentedString(this.callerAddress)).append("\n");
        sb.append("    callerName: ").append(this.toIndentedString(this.callerName)).append("\n");
        sb.append("    callerUser: ").append(this.toIndentedString(this.callerUser)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    copiedFrom: ").append(this.toIndentedString(this.copiedFrom)).append("\n");
        sb.append("    copiedTo: ").append(this.toIndentedString(this.copiedTo)).append("\n");
        sb.append("    retentionPolicy: ").append(this.toIndentedString(this.retentionPolicy)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

