/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ScimGenesysUserExternalId;
import com.mypurecloud.sdk.v2.model.ScimUserRoutingLanguage;
import com.mypurecloud.sdk.v2.model.ScimUserRoutingSkill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Genesys Cloud user extensions to SCIM RFC.")
public class ScimUserExtensions
implements Serializable {
    private List<ScimUserRoutingSkill> routingSkills = new ArrayList<ScimUserRoutingSkill>();
    private List<ScimUserRoutingLanguage> routingLanguages = new ArrayList<ScimUserRoutingLanguage>();
    private List<ScimGenesysUserExternalId> externalIds = new ArrayList<ScimGenesysUserExternalId>();

    public ScimUserExtensions routingSkills(List<ScimUserRoutingSkill> routingSkills) {
        this.routingSkills = routingSkills;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of routing skills assigned to a user. Maximum 50 skills.")
    @JsonProperty(value="routingSkills")
    public List<ScimUserRoutingSkill> getRoutingSkills() {
        return this.routingSkills;
    }

    public void setRoutingSkills(List<ScimUserRoutingSkill> routingSkills) {
        this.routingSkills = routingSkills;
    }

    public ScimUserExtensions routingLanguages(List<ScimUserRoutingLanguage> routingLanguages) {
        this.routingLanguages = routingLanguages;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of routing languages assigned to a user. Maximum 50 languages.")
    @JsonProperty(value="routingLanguages")
    public List<ScimUserRoutingLanguage> getRoutingLanguages() {
        return this.routingLanguages;
    }

    public void setRoutingLanguages(List<ScimUserRoutingLanguage> routingLanguages) {
        this.routingLanguages = routingLanguages;
    }

    public ScimUserExtensions externalIds(List<ScimGenesysUserExternalId> externalIds) {
        this.externalIds = externalIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of external identifiers assigned to user. Always includes an immutable SCIM authority prefixed with \"x-pc:scimv2:v1\". ExternalIds are searchable with complex filter query parameter using 'authority' and 'value', e.g., filter=urn:ietf:params:scim:schemas:extension:genesys:purecloud:2.0:User:externalIds[authority eq \"matchAuthName\" and value eq \"matchingExternalKeyValue\"].")
    @JsonProperty(value="externalIds")
    public List<ScimGenesysUserExternalId> getExternalIds() {
        return this.externalIds;
    }

    public void setExternalIds(List<ScimGenesysUserExternalId> externalIds) {
        this.externalIds = externalIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimUserExtensions scimUserExtensions = (ScimUserExtensions)o;
        return Objects.equals(this.routingSkills, scimUserExtensions.routingSkills) && Objects.equals(this.routingLanguages, scimUserExtensions.routingLanguages) && Objects.equals(this.externalIds, scimUserExtensions.externalIds);
    }

    public int hashCode() {
        return Objects.hash(this.routingSkills, this.routingLanguages, this.externalIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimUserExtensions {\n");
        sb.append("    routingSkills: ").append(this.toIndentedString(this.routingSkills)).append("\n");
        sb.append("    routingLanguages: ").append(this.toIndentedString(this.routingLanguages)).append("\n");
        sb.append("    externalIds: ").append(this.toIndentedString(this.externalIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

