/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.MessagingSettingReference;
import com.mypurecloud.sdk.v2.model.SupportedContentReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class WhatsAppIntegrationUpdateRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private SupportedContentReference supportedContent = null;
    private MessagingSettingReference messagingSetting = null;
    private ActionEnum action = null;
    private AuthenticationMethodEnum authenticationMethod = null;
    private String confirmationCode = null;
    private String phoneNumber = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WhatsAppIntegrationUpdateRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="WhatsApp Integration name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WhatsAppIntegrationUpdateRequest supportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines the SupportedContent profile configured for an integration")
    @JsonProperty(value="supportedContent")
    public SupportedContentReference getSupportedContent() {
        return this.supportedContent;
    }

    public void setSupportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
    }

    public WhatsAppIntegrationUpdateRequest messagingSetting(MessagingSettingReference messagingSetting) {
        this.messagingSetting = messagingSetting;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="messagingSetting")
    public MessagingSettingReference getMessagingSetting() {
        return this.messagingSetting;
    }

    public void setMessagingSetting(MessagingSettingReference messagingSetting) {
        this.messagingSetting = messagingSetting;
    }

    public WhatsAppIntegrationUpdateRequest action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="The action used to activate and then confirm a WhatsApp Integration.")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public WhatsAppIntegrationUpdateRequest authenticationMethod(AuthenticationMethodEnum authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="The authentication method used to confirm a WhatsApp Integration activation. If action is set to Activate, then authenticationMethod is a required field. ")
    @JsonProperty(value="authenticationMethod")
    public AuthenticationMethodEnum getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(AuthenticationMethodEnum authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public WhatsAppIntegrationUpdateRequest confirmationCode(String confirmationCode) {
        this.confirmationCode = confirmationCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The confirmation code sent by Whatsapp to you during the activation step. If action is set to Confirm, then confirmationCode is a required field.")
    @JsonProperty(value="confirmationCode")
    public String getConfirmationCode() {
        return this.confirmationCode;
    }

    public void setConfirmationCode(String confirmationCode) {
        this.confirmationCode = confirmationCode;
    }

    public WhatsAppIntegrationUpdateRequest phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Phone number to associate with the WhatsApp integration")
    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsAppIntegrationUpdateRequest whatsAppIntegrationUpdateRequest = (WhatsAppIntegrationUpdateRequest)o;
        return Objects.equals(this.id, whatsAppIntegrationUpdateRequest.id) && Objects.equals(this.name, whatsAppIntegrationUpdateRequest.name) && Objects.equals(this.supportedContent, whatsAppIntegrationUpdateRequest.supportedContent) && Objects.equals(this.messagingSetting, whatsAppIntegrationUpdateRequest.messagingSetting) && Objects.equals((Object)this.action, (Object)whatsAppIntegrationUpdateRequest.action) && Objects.equals((Object)this.authenticationMethod, (Object)whatsAppIntegrationUpdateRequest.authenticationMethod) && Objects.equals(this.confirmationCode, whatsAppIntegrationUpdateRequest.confirmationCode) && Objects.equals(this.phoneNumber, whatsAppIntegrationUpdateRequest.phoneNumber) && Objects.equals(this.selfUri, whatsAppIntegrationUpdateRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.supportedContent, this.messagingSetting, this.action, this.authenticationMethod, this.confirmationCode, this.phoneNumber, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsAppIntegrationUpdateRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    supportedContent: ").append(this.toIndentedString(this.supportedContent)).append("\n");
        sb.append("    messagingSetting: ").append(this.toIndentedString(this.messagingSetting)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    authenticationMethod: ").append(this.toIndentedString((Object)this.authenticationMethod)).append("\n");
        sb.append("    confirmationCode: ").append(this.toIndentedString(this.confirmationCode)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AuthenticationMethodEnumDeserializer.class)
    public static enum AuthenticationMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SMS("Sms"),
        VOICE("Voice");

        private String value;

        private AuthenticationMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AuthenticationMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AuthenticationMethodEnum value : AuthenticationMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AuthenticationMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AuthenticationMethodEnumDeserializer
    extends StdDeserializer<AuthenticationMethodEnum> {
        public AuthenticationMethodEnumDeserializer() {
            super(AuthenticationMethodEnumDeserializer.class);
        }

        public AuthenticationMethodEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AuthenticationMethodEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=ActionEnumDeserializer.class)
    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVATE("Activate"),
        CONFIRM("Confirm");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionEnumDeserializer
    extends StdDeserializer<ActionEnum> {
        public ActionEnumDeserializer() {
            super(ActionEnumDeserializer.class);
        }

        public ActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

