/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Information about the recipient the message is sent to.")
public class OpenMessagingToRecipient
implements Serializable {
    private String nickname = null;
    private String id = null;
    private IdTypeEnum idType = null;
    private String firstName = null;
    private String lastName = null;
    private String image = null;
    private String email = null;

    @ApiModelProperty(example="null", value="Nickname or display name of the recipient.")
    @JsonProperty(value="nickname")
    public String getNickname() {
        return this.nickname;
    }

    public OpenMessagingToRecipient id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The recipient ID specific to the provider.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", value="The recipient ID type. This is used to indicate the format used for the ID.")
    @JsonProperty(value="idType")
    public IdTypeEnum getIdType() {
        return this.idType;
    }

    @ApiModelProperty(example="null", value="First name of the recipient.")
    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    @ApiModelProperty(example="null", value="Last name of the recipient.")
    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    @ApiModelProperty(example="null", value="URL of an image that represents the recipient.")
    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    public OpenMessagingToRecipient email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="null", value="E-mail address of the recipient.")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenMessagingToRecipient openMessagingToRecipient = (OpenMessagingToRecipient)o;
        return Objects.equals(this.nickname, openMessagingToRecipient.nickname) && Objects.equals(this.id, openMessagingToRecipient.id) && Objects.equals((Object)this.idType, (Object)openMessagingToRecipient.idType) && Objects.equals(this.firstName, openMessagingToRecipient.firstName) && Objects.equals(this.lastName, openMessagingToRecipient.lastName) && Objects.equals(this.image, openMessagingToRecipient.image) && Objects.equals(this.email, openMessagingToRecipient.email);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nickname, this.id, this.idType, this.firstName, this.lastName, this.image, this.email});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenMessagingToRecipient {\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    idType: ").append(this.toIndentedString((Object)this.idType)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=IdTypeEnumDeserializer.class)
    public static enum IdTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EMAIL("Email"),
        PHONE("Phone"),
        OPAQUE("Opaque");

        private String value;

        private IdTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static IdTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (IdTypeEnum value : IdTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return IdTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class IdTypeEnumDeserializer
    extends StdDeserializer<IdTypeEnum> {
        public IdTypeEnumDeserializer() {
            super(IdTypeEnumDeserializer.class);
        }

        public IdTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return IdTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

