/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Facet;
import com.mypurecloud.sdk.v2.model.Filter;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TrusteeAuditQueryRequest
implements Serializable {
    private List<String> trusteeOrganizationIds = new ArrayList<String>();
    private List<String> trusteeUserIds = new ArrayList<String>();
    private Date startDate = null;
    private Date endDate = null;
    private String queryPhrase = null;
    private List<Facet> facets = new ArrayList<Facet>();
    private List<Filter> filters = new ArrayList<Filter>();

    public TrusteeAuditQueryRequest trusteeOrganizationIds(List<String> trusteeOrganizationIds) {
        this.trusteeOrganizationIds = trusteeOrganizationIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Limit returned audits to these trustee organizationIds.")
    @JsonProperty(value="trusteeOrganizationIds")
    public List<String> getTrusteeOrganizationIds() {
        return this.trusteeOrganizationIds;
    }

    public void setTrusteeOrganizationIds(List<String> trusteeOrganizationIds) {
        this.trusteeOrganizationIds = trusteeOrganizationIds;
    }

    public TrusteeAuditQueryRequest trusteeUserIds(List<String> trusteeUserIds) {
        this.trusteeUserIds = trusteeUserIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Limit returned audits to these trustee userIds.")
    @JsonProperty(value="trusteeUserIds")
    public List<String> getTrusteeUserIds() {
        return this.trusteeUserIds;
    }

    public void setTrusteeUserIds(List<String> trusteeUserIds) {
        this.trusteeUserIds = trusteeUserIds;
    }

    public TrusteeAuditQueryRequest startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Starting date/time for the audit search. ISO-8601 formatted date-time, UTC.")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public TrusteeAuditQueryRequest endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Ending date/time for the audit search. ISO-8601 formatted date-time, UTC.")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public TrusteeAuditQueryRequest queryPhrase(String queryPhrase) {
        this.queryPhrase = queryPhrase;
        return this;
    }

    @ApiModelProperty(example="null", value="Word or phrase to look for in audit bodies.")
    @JsonProperty(value="queryPhrase")
    public String getQueryPhrase() {
        return this.queryPhrase;
    }

    public void setQueryPhrase(String queryPhrase) {
        this.queryPhrase = queryPhrase;
    }

    public TrusteeAuditQueryRequest facets(List<Facet> facets) {
        this.facets = facets;
        return this;
    }

    @ApiModelProperty(example="null", value="Facet information to be returned with the query results.")
    @JsonProperty(value="facets")
    public List<Facet> getFacets() {
        return this.facets;
    }

    public void setFacets(List<Facet> facets) {
        this.facets = facets;
    }

    public TrusteeAuditQueryRequest filters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional custom filters to be applied to the query.")
    @JsonProperty(value="filters")
    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrusteeAuditQueryRequest trusteeAuditQueryRequest = (TrusteeAuditQueryRequest)o;
        return Objects.equals(this.trusteeOrganizationIds, trusteeAuditQueryRequest.trusteeOrganizationIds) && Objects.equals(this.trusteeUserIds, trusteeAuditQueryRequest.trusteeUserIds) && Objects.equals(this.startDate, trusteeAuditQueryRequest.startDate) && Objects.equals(this.endDate, trusteeAuditQueryRequest.endDate) && Objects.equals(this.queryPhrase, trusteeAuditQueryRequest.queryPhrase) && Objects.equals(this.facets, trusteeAuditQueryRequest.facets) && Objects.equals(this.filters, trusteeAuditQueryRequest.filters);
    }

    public int hashCode() {
        return Objects.hash(this.trusteeOrganizationIds, this.trusteeUserIds, this.startDate, this.endDate, this.queryPhrase, this.facets, this.filters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrusteeAuditQueryRequest {\n");
        sb.append("    trusteeOrganizationIds: ").append(this.toIndentedString(this.trusteeOrganizationIds)).append("\n");
        sb.append("    trusteeUserIds: ").append(this.toIndentedString(this.trusteeUserIds)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    queryPhrase: ").append(this.toIndentedString(this.queryPhrase)).append("\n");
        sb.append("    facets: ").append(this.toIndentedString(this.facets)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

