/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.RoutingConversationAttributesRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchRoutingConversationRequest {
    private String conversationId;
    private RoutingConversationAttributesRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PatchRoutingConversationRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public RoutingConversationAttributesRequest getBody() {
        return this.body;
    }

    public void setBody(RoutingConversationAttributesRequest body) {
        this.body = body;
    }

    public PatchRoutingConversationRequest withBody(RoutingConversationAttributesRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchRoutingConversationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<RoutingConversationAttributesRequest> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PatchRoutingConversationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchRoutingConversationRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/routing/conversations/{conversationId}").withPathParameter("conversationId", this.conversationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, RoutingConversationAttributesRequest body) {
        return new Builder().withRequiredParams(conversationId, body);
    }

    public static class Builder {
        private final PatchRoutingConversationRequest request = new PatchRoutingConversationRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withBody(RoutingConversationAttributesRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, RoutingConversationAttributesRequest body) {
            this.request.setConversationId(conversationId);
            this.request.setBody(body);
            return this;
        }

        public PatchRoutingConversationRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PatchRoutingConversationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchRoutingConversationRequest.");
            }
            return this.request;
        }
    }
}

