/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.QueueMember;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatchRoutingQueueMembersRequest {
    private String queueId;
    private List<QueueMember> body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public PatchRoutingQueueMembersRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public List<QueueMember> getBody() {
        return this.body;
    }

    public void setBody(List<QueueMember> body) {
        this.body = body;
    }

    public PatchRoutingQueueMembersRequest withBody(List<QueueMember> body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchRoutingQueueMembersRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<List<QueueMember>> withHttpInfo() {
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PatchRoutingQueueMembersRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchRoutingQueueMembersRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/routing/queues/{queueId}/members").withPathParameter("queueId", this.queueId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String queueId, List<QueueMember> body) {
        return new Builder().withRequiredParams(queueId, body);
    }

    public static class Builder {
        private final PatchRoutingQueueMembersRequest request = new PatchRoutingQueueMembersRequest();

        private Builder() {
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withBody(List<QueueMember> body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String queueId, List<QueueMember> body) {
            this.request.setQueueId(queueId);
            this.request.setBody(body);
            return this;
        }

        public PatchRoutingQueueMembersRequest build() {
            if (this.request.queueId == null) {
                throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PatchRoutingQueueMembersRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchRoutingQueueMembersRequest.");
            }
            return this.request;
        }
    }
}

