/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class PostWebchatGuestConversationMemberTypingRequest {
    private String conversationId;
    private String memberId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostWebchatGuestConversationMemberTypingRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public PostWebchatGuestConversationMemberTypingRequest withMemberId(String memberId) {
        this.setMemberId(memberId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostWebchatGuestConversationMemberTypingRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostWebchatGuestConversationMemberTypingRequest.");
        }
        if (this.memberId == null) {
            throw new IllegalStateException("Missing the required parameter 'memberId' when building request for PostWebchatGuestConversationMemberTypingRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/webchat/guest/conversations/{conversationId}/members/{memberId}/typing").withPathParameter("conversationId", this.conversationId).withPathParameter("memberId", this.memberId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("Guest Chat JWT").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String memberId) {
        return new Builder().withRequiredParams(conversationId, memberId);
    }

    public static class Builder {
        private final PostWebchatGuestConversationMemberTypingRequest request = new PostWebchatGuestConversationMemberTypingRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withMemberId(String memberId) {
            this.request.setMemberId(memberId);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String memberId) {
            this.request.setConversationId(conversationId);
            this.request.setMemberId(memberId);
            return this;
        }

        public PostWebchatGuestConversationMemberTypingRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostWebchatGuestConversationMemberTypingRequest.");
            }
            if (this.request.memberId == null) {
                throw new IllegalStateException("Missing the required parameter 'memberId' when building request for PostWebchatGuestConversationMemberTypingRequest.");
            }
            return this.request;
        }
    }
}

