/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ImportReport;
import com.mypurecloud.sdk.v2.model.KnowledgeBase;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class KnowledgeImport
implements Serializable {
    private String id = null;
    private String name = null;
    private String uploadKey = null;
    private FileTypeEnum fileType = null;
    private Boolean ignoreHeaders = null;
    private StatusEnum status = null;
    private ImportReport report = null;
    private KnowledgeBase knowledgeBase = null;
    private LanguageCodeEnum languageCode = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="Id of the import operation")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeImport name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the import operation")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public KnowledgeImport uploadKey(String uploadKey) {
        this.uploadKey = uploadKey;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Upload key")
    @JsonProperty(value="uploadKey")
    public String getUploadKey() {
        return this.uploadKey;
    }

    public void setUploadKey(String uploadKey) {
        this.uploadKey = uploadKey;
    }

    public KnowledgeImport fileType(FileTypeEnum fileType) {
        this.fileType = fileType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="file type of the document")
    @JsonProperty(value="fileType")
    public FileTypeEnum getFileType() {
        return this.fileType;
    }

    public void setFileType(FileTypeEnum fileType) {
        this.fileType = fileType;
    }

    public KnowledgeImport ignoreHeaders(Boolean ignoreHeaders) {
        this.ignoreHeaders = ignoreHeaders;
        return this;
    }

    @ApiModelProperty(example="null", value="Ignore headers for the specified file")
    @JsonProperty(value="ignoreHeaders")
    public Boolean getIgnoreHeaders() {
        return this.ignoreHeaders;
    }

    public void setIgnoreHeaders(Boolean ignoreHeaders) {
        this.ignoreHeaders = ignoreHeaders;
    }

    @ApiModelProperty(example="null", value="Status of the operation")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Report of the import operation")
    @JsonProperty(value="report")
    public ImportReport getReport() {
        return this.report;
    }

    @ApiModelProperty(example="null", value="Knowledge base which document import does belong to")
    @JsonProperty(value="knowledgeBase")
    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    @ApiModelProperty(example="null", value="Language code")
    @JsonProperty(value="languageCode")
    public LanguageCodeEnum getLanguageCode() {
        return this.languageCode;
    }

    @ApiModelProperty(example="null", value="Created date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeImport knowledgeImport = (KnowledgeImport)o;
        return Objects.equals(this.id, knowledgeImport.id) && Objects.equals(this.name, knowledgeImport.name) && Objects.equals(this.uploadKey, knowledgeImport.uploadKey) && Objects.equals((Object)this.fileType, (Object)knowledgeImport.fileType) && Objects.equals(this.ignoreHeaders, knowledgeImport.ignoreHeaders) && Objects.equals((Object)this.status, (Object)knowledgeImport.status) && Objects.equals(this.report, knowledgeImport.report) && Objects.equals(this.knowledgeBase, knowledgeImport.knowledgeBase) && Objects.equals((Object)this.languageCode, (Object)knowledgeImport.languageCode) && Objects.equals(this.dateCreated, knowledgeImport.dateCreated) && Objects.equals(this.dateModified, knowledgeImport.dateModified) && Objects.equals(this.selfUri, knowledgeImport.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.uploadKey, this.fileType, this.ignoreHeaders, this.status, this.report, this.knowledgeBase, this.languageCode, this.dateCreated, this.dateModified, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeImport {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    uploadKey: ").append(this.toIndentedString(this.uploadKey)).append("\n");
        sb.append("    fileType: ").append(this.toIndentedString((Object)this.fileType)).append("\n");
        sb.append("    ignoreHeaders: ").append(this.toIndentedString(this.ignoreHeaders)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    report: ").append(this.toIndentedString(this.report)).append("\n");
        sb.append("    knowledgeBase: ").append(this.toIndentedString(this.knowledgeBase)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString((Object)this.languageCode)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LanguageCodeEnumDeserializer.class)
    public static enum LanguageCodeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EN_US("en-US"),
        EN_UK("en-UK"),
        EN_AU("en-AU"),
        DE_DE("de-DE");

        private String value;

        private LanguageCodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LanguageCodeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LanguageCodeEnum value : LanguageCodeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LanguageCodeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class LanguageCodeEnumDeserializer
    extends StdDeserializer<LanguageCodeEnum> {
        public LanguageCodeEnumDeserializer() {
            super(LanguageCodeEnumDeserializer.class);
        }

        public LanguageCodeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LanguageCodeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATED("Created"),
        VALIDATIONINPROGRESS("ValidationInProgress"),
        VALIDATIONCOMPLETED("ValidationCompleted"),
        VALIDATIONFAILED("ValidationFailed"),
        STARTED("Started"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        PARTIALCOMPLETED("PartialCompleted"),
        FAILED("Failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=FileTypeEnumDeserializer.class)
    public static enum FileTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CSV("Csv"),
        JSONLINES("JsonLines");

        private String value;

        private FileTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FileTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FileTypeEnum value : FileTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FileTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FileTypeEnumDeserializer
    extends StdDeserializer<FileTypeEnum> {
        public FileTypeEnumDeserializer() {
            super(FileTypeEnumDeserializer.class);
        }

        public FileTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FileTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

