/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.AuthenticationSettings;
import com.mypurecloud.sdk.v2.model.CobrowseSettings;
import com.mypurecloud.sdk.v2.model.JourneyEventsSettings;
import com.mypurecloud.sdk.v2.model.MessengerSettings;
import com.mypurecloud.sdk.v2.model.PositionSettings;
import com.mypurecloud.sdk.v2.model.SupportCenterSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details about the configuration version of a Web Deployment")
public class WebDeploymentConfigurationVersion
implements Serializable {
    private String id = null;
    private String name = null;
    private String version = null;
    private String description = null;
    private List<String> languages = new ArrayList<String>();
    private String defaultLanguage = null;
    private MessengerSettings messenger = null;
    private PositionSettings position = null;
    private SupportCenterSettings supportCenter = null;
    private CobrowseSettings cobrowse = null;
    private JourneyEventsSettings journeyEvents = null;
    private AuthenticationSettings authenticationSettings = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Date datePublished = null;
    private AddressableEntityRef lastModifiedUser = null;
    private AddressableEntityRef createdUser = null;
    private AddressableEntityRef publishedUser = null;
    private StatusEnum status = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The configuration version ID")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WebDeploymentConfigurationVersion name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The configuration version name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="DRAFT, 1, 2", value="The version of the configuration")
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    public WebDeploymentConfigurationVersion description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the configuration")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WebDeploymentConfigurationVersion languages(List<String> languages) {
        this.languages = languages;
        return this;
    }

    @ApiModelProperty(example="en-us, de-de", value="A list of languages supported on the configuration")
    @JsonProperty(value="languages")
    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public WebDeploymentConfigurationVersion defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    @ApiModelProperty(example="en-us, de-de", value="The default language to use for the configuration")
    @JsonProperty(value="defaultLanguage")
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public WebDeploymentConfigurationVersion messenger(MessengerSettings messenger) {
        this.messenger = messenger;
        return this;
    }

    @ApiModelProperty(example="null", value="The settings for messenger")
    @JsonProperty(value="messenger")
    public MessengerSettings getMessenger() {
        return this.messenger;
    }

    public void setMessenger(MessengerSettings messenger) {
        this.messenger = messenger;
    }

    public WebDeploymentConfigurationVersion position(PositionSettings position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(example="null", value="The settings for position")
    @JsonProperty(value="position")
    public PositionSettings getPosition() {
        return this.position;
    }

    public void setPosition(PositionSettings position) {
        this.position = position;
    }

    public WebDeploymentConfigurationVersion supportCenter(SupportCenterSettings supportCenter) {
        this.supportCenter = supportCenter;
        return this;
    }

    @ApiModelProperty(example="null", value="The settings for support center")
    @JsonProperty(value="supportCenter")
    public SupportCenterSettings getSupportCenter() {
        return this.supportCenter;
    }

    public void setSupportCenter(SupportCenterSettings supportCenter) {
        this.supportCenter = supportCenter;
    }

    public WebDeploymentConfigurationVersion cobrowse(CobrowseSettings cobrowse) {
        this.cobrowse = cobrowse;
        return this;
    }

    @ApiModelProperty(example="null", value="The settings for cobrowse")
    @JsonProperty(value="cobrowse")
    public CobrowseSettings getCobrowse() {
        return this.cobrowse;
    }

    public void setCobrowse(CobrowseSettings cobrowse) {
        this.cobrowse = cobrowse;
    }

    public WebDeploymentConfigurationVersion journeyEvents(JourneyEventsSettings journeyEvents) {
        this.journeyEvents = journeyEvents;
        return this;
    }

    @ApiModelProperty(example="null", value="The settings for journey events")
    @JsonProperty(value="journeyEvents")
    public JourneyEventsSettings getJourneyEvents() {
        return this.journeyEvents;
    }

    public void setJourneyEvents(JourneyEventsSettings journeyEvents) {
        this.journeyEvents = journeyEvents;
    }

    public WebDeploymentConfigurationVersion authenticationSettings(AuthenticationSettings authenticationSettings) {
        this.authenticationSettings = authenticationSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="The settings for authenticated deployments")
    @JsonProperty(value="authenticationSettings")
    public AuthenticationSettings getAuthenticationSettings() {
        return this.authenticationSettings;
    }

    public void setAuthenticationSettings(AuthenticationSettings authenticationSettings) {
        this.authenticationSettings = authenticationSettings;
    }

    @ApiModelProperty(example="null", value="The date the configuration version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date the configuration version was most recently modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The date the configuration version was most recently published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="datePublished")
    public Date getDatePublished() {
        return this.datePublished;
    }

    @ApiModelProperty(example="null", value="A reference to the user who most recently modified the configuration version")
    @JsonProperty(value="lastModifiedUser")
    public AddressableEntityRef getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    @ApiModelProperty(example="null", value="A reference to the user who created the configuration version")
    @JsonProperty(value="createdUser")
    public AddressableEntityRef getCreatedUser() {
        return this.createdUser;
    }

    @ApiModelProperty(example="null", value="A reference to the user who published the configuration version")
    @JsonProperty(value="publishedUser")
    public AddressableEntityRef getPublishedUser() {
        return this.publishedUser;
    }

    public WebDeploymentConfigurationVersion status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The current status of the configuration version")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebDeploymentConfigurationVersion webDeploymentConfigurationVersion = (WebDeploymentConfigurationVersion)o;
        return Objects.equals(this.id, webDeploymentConfigurationVersion.id) && Objects.equals(this.name, webDeploymentConfigurationVersion.name) && Objects.equals(this.version, webDeploymentConfigurationVersion.version) && Objects.equals(this.description, webDeploymentConfigurationVersion.description) && Objects.equals(this.languages, webDeploymentConfigurationVersion.languages) && Objects.equals(this.defaultLanguage, webDeploymentConfigurationVersion.defaultLanguage) && Objects.equals(this.messenger, webDeploymentConfigurationVersion.messenger) && Objects.equals(this.position, webDeploymentConfigurationVersion.position) && Objects.equals(this.supportCenter, webDeploymentConfigurationVersion.supportCenter) && Objects.equals(this.cobrowse, webDeploymentConfigurationVersion.cobrowse) && Objects.equals(this.journeyEvents, webDeploymentConfigurationVersion.journeyEvents) && Objects.equals(this.authenticationSettings, webDeploymentConfigurationVersion.authenticationSettings) && Objects.equals(this.dateCreated, webDeploymentConfigurationVersion.dateCreated) && Objects.equals(this.dateModified, webDeploymentConfigurationVersion.dateModified) && Objects.equals(this.datePublished, webDeploymentConfigurationVersion.datePublished) && Objects.equals(this.lastModifiedUser, webDeploymentConfigurationVersion.lastModifiedUser) && Objects.equals(this.createdUser, webDeploymentConfigurationVersion.createdUser) && Objects.equals(this.publishedUser, webDeploymentConfigurationVersion.publishedUser) && Objects.equals((Object)this.status, (Object)webDeploymentConfigurationVersion.status) && Objects.equals(this.selfUri, webDeploymentConfigurationVersion.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.version, this.description, this.languages, this.defaultLanguage, this.messenger, this.position, this.supportCenter, this.cobrowse, this.journeyEvents, this.authenticationSettings, this.dateCreated, this.dateModified, this.datePublished, this.lastModifiedUser, this.createdUser, this.publishedUser, this.status, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebDeploymentConfigurationVersion {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    languages: ").append(this.toIndentedString(this.languages)).append("\n");
        sb.append("    defaultLanguage: ").append(this.toIndentedString(this.defaultLanguage)).append("\n");
        sb.append("    messenger: ").append(this.toIndentedString(this.messenger)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    supportCenter: ").append(this.toIndentedString(this.supportCenter)).append("\n");
        sb.append("    cobrowse: ").append(this.toIndentedString(this.cobrowse)).append("\n");
        sb.append("    journeyEvents: ").append(this.toIndentedString(this.journeyEvents)).append("\n");
        sb.append("    authenticationSettings: ").append(this.toIndentedString(this.authenticationSettings)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    datePublished: ").append(this.toIndentedString(this.datePublished)).append("\n");
        sb.append("    lastModifiedUser: ").append(this.toIndentedString(this.lastModifiedUser)).append("\n");
        sb.append("    createdUser: ").append(this.toIndentedString(this.createdUser)).append("\n");
        sb.append("    publishedUser: ").append(this.toIndentedString(this.publishedUser)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("Pending"),
        ACTIVE("Active"),
        INACTIVE("Inactive"),
        ERROR("Error"),
        DELETING("Deleting");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

