/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.KnowledgeContextRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchKnowledgeKnowledgebaseContextRequest {
    private String knowledgeBaseId;
    private String contextId;
    private KnowledgeContextRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PatchKnowledgeKnowledgebaseContextRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public PatchKnowledgeKnowledgebaseContextRequest withContextId(String contextId) {
        this.setContextId(contextId);
        return this;
    }

    public KnowledgeContextRequest getBody() {
        return this.body;
    }

    public void setBody(KnowledgeContextRequest body) {
        this.body = body;
    }

    public PatchKnowledgeKnowledgebaseContextRequest withBody(KnowledgeContextRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchKnowledgeKnowledgebaseContextRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<KnowledgeContextRequest> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseContextRequest.");
        }
        if (this.contextId == null) {
            throw new IllegalStateException("Missing the required parameter 'contextId' when building request for PatchKnowledgeKnowledgebaseContextRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/contexts/{contextId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("contextId", this.contextId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String contextId) {
        return new Builder().withRequiredParams(knowledgeBaseId, contextId);
    }

    public static class Builder {
        private final PatchKnowledgeKnowledgebaseContextRequest request = new PatchKnowledgeKnowledgebaseContextRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withContextId(String contextId) {
            this.request.setContextId(contextId);
            return this;
        }

        public Builder withBody(KnowledgeContextRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String contextId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setContextId(contextId);
            return this;
        }

        public PatchKnowledgeKnowledgebaseContextRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseContextRequest.");
            }
            if (this.request.contextId == null) {
                throw new IllegalStateException("Missing the required parameter 'contextId' when building request for PatchKnowledgeKnowledgebaseContextRequest.");
            }
            return this.request;
        }
    }
}

