/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ConversationContentAttachment;
import com.mypurecloud.sdk.v2.model.ConversationContentButtonResponse;
import com.mypurecloud.sdk.v2.model.ConversationContentGeneric;
import com.mypurecloud.sdk.v2.model.ConversationContentLocation;
import com.mypurecloud.sdk.v2.model.ConversationContentNotificationTemplate;
import com.mypurecloud.sdk.v2.model.ConversationContentQuickReply;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Message content element.")
public class ConversationMessageContent
implements Serializable {
    private ContentTypeEnum contentType = null;
    private ConversationContentLocation location = null;
    private ConversationContentAttachment attachment = null;
    private ConversationContentQuickReply quickReply = null;
    private ConversationContentNotificationTemplate template = null;
    private ConversationContentButtonResponse buttonResponse = null;
    private ConversationContentGeneric generic = null;

    public ConversationMessageContent contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of this content element. If contentType = \"Attachment\" only one item is allowed.")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public ConversationMessageContent location(ConversationContentLocation location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="null", value="Location content.")
    @JsonProperty(value="location")
    public ConversationContentLocation getLocation() {
        return this.location;
    }

    public void setLocation(ConversationContentLocation location) {
        this.location = location;
    }

    public ConversationMessageContent attachment(ConversationContentAttachment attachment) {
        this.attachment = attachment;
        return this;
    }

    @ApiModelProperty(example="null", value="Attachment content.")
    @JsonProperty(value="attachment")
    public ConversationContentAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(ConversationContentAttachment attachment) {
        this.attachment = attachment;
    }

    public ConversationMessageContent quickReply(ConversationContentQuickReply quickReply) {
        this.quickReply = quickReply;
        return this;
    }

    @ApiModelProperty(example="null", value="Quick reply content.")
    @JsonProperty(value="quickReply")
    public ConversationContentQuickReply getQuickReply() {
        return this.quickReply;
    }

    public void setQuickReply(ConversationContentQuickReply quickReply) {
        this.quickReply = quickReply;
    }

    public ConversationMessageContent template(ConversationContentNotificationTemplate template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(example="null", value="Template notification content.")
    @JsonProperty(value="template")
    public ConversationContentNotificationTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ConversationContentNotificationTemplate template) {
        this.template = template;
    }

    public ConversationMessageContent buttonResponse(ConversationContentButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
        return this;
    }

    @ApiModelProperty(example="null", value="Button response content.")
    @JsonProperty(value="buttonResponse")
    public ConversationContentButtonResponse getButtonResponse() {
        return this.buttonResponse;
    }

    public void setButtonResponse(ConversationContentButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
    }

    public ConversationMessageContent generic(ConversationContentGeneric generic) {
        this.generic = generic;
        return this;
    }

    @ApiModelProperty(example="null", value="Generic Template Object")
    @JsonProperty(value="generic")
    public ConversationContentGeneric getGeneric() {
        return this.generic;
    }

    public void setGeneric(ConversationContentGeneric generic) {
        this.generic = generic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationMessageContent conversationMessageContent = (ConversationMessageContent)o;
        return Objects.equals((Object)this.contentType, (Object)conversationMessageContent.contentType) && Objects.equals(this.location, conversationMessageContent.location) && Objects.equals(this.attachment, conversationMessageContent.attachment) && Objects.equals(this.quickReply, conversationMessageContent.quickReply) && Objects.equals(this.template, conversationMessageContent.template) && Objects.equals(this.buttonResponse, conversationMessageContent.buttonResponse) && Objects.equals(this.generic, conversationMessageContent.generic);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentType, this.location, this.attachment, this.quickReply, this.template, this.buttonResponse, this.generic});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationMessageContent {\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    quickReply: ").append(this.toIndentedString(this.quickReply)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    buttonResponse: ").append(this.toIndentedString(this.buttonResponse)).append("\n");
        sb.append("    generic: ").append(this.toIndentedString(this.generic)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContentTypeEnumDeserializer.class)
    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTACHMENT("Attachment"),
        LOCATION("Location"),
        QUICKREPLY("QuickReply"),
        NOTIFICATION("Notification"),
        BUTTONRESPONSE("ButtonResponse"),
        GENERICTEMPLATE("GenericTemplate");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ContentTypeEnumDeserializer
    extends StdDeserializer<ContentTypeEnum> {
        public ContentTypeEnumDeserializer() {
            super(ContentTypeEnumDeserializer.class);
        }

        public ContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

